/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.content;

import android.graphics.Path;
import android.graphics.PointF;
import java.util.List;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.animation.content.CompoundTrimPathContent;
import oz.lottie.animation.content.Content;
import oz.lottie.animation.content.KeyPathElementContent;
import oz.lottie.animation.content.PathContent;
import oz.lottie.animation.content.TrimPathContent;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.model.KeyPath;
import oz.lottie.model.content.CircleShape;
import oz.lottie.model.content.ShapeTrimPath$Type;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.utils.MiscUtils;
import oz.lottie.value.LottieValueCallback;

public class EllipseContent
implements KeyPathElementContent,
PathContent,
BaseKeyframeAnimation$AnimationListener {
    private static final float ELLIPSE_CONTROL_POINT_PERCENTAGE = 0.55228f;
    private final Path path = new Path();
    private final String name;
    private final LottieDrawable lottieDrawable;
    private final BaseKeyframeAnimation sizeAnimation;
    private final BaseKeyframeAnimation positionAnimation;
    private final CircleShape circleShape;
    private CompoundTrimPathContent trimPaths = new CompoundTrimPathContent();
    private boolean isPathValid;

    public EllipseContent(LottieDrawable lottieDrawable, BaseLayer baseLayer, CircleShape circleShape) {
        this.name = circleShape.getName();
        this.lottieDrawable = lottieDrawable;
        this.sizeAnimation = circleShape.getSize().createAnimation();
        this.positionAnimation = circleShape.getPosition().createAnimation();
        this.circleShape = circleShape;
        baseLayer.addAnimation(this.sizeAnimation);
        baseLayer.addAnimation(this.positionAnimation);
        this.sizeAnimation.addUpdateListener(this);
        this.positionAnimation.addUpdateListener(this);
    }

    @Override
    public void onValueChanged() {
        this.invalidate();
    }

    private void invalidate() {
        this.isPathValid = false;
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List list, List list2) {
        int n = 0;
        while (n < list.size()) {
            Content content = (Content)list.get(n);
            if (content instanceof TrimPathContent && ((TrimPathContent)content).getType() == ShapeTrimPath$Type.SIMULTANEOUSLY) {
                TrimPathContent trimPathContent = (TrimPathContent)content;
                this.trimPaths.addTrimPath(trimPathContent);
                trimPathContent.addListener(this);
            }
            ++n;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Path getPath() {
        if (this.isPathValid) {
            return this.path;
        }
        this.path.reset();
        if (this.circleShape.isHidden()) {
            this.isPathValid = true;
            return this.path;
        }
        PointF pointF = (PointF)this.sizeAnimation.getValue();
        float f2 = pointF.x / 2.0f;
        float f3 = pointF.y / 2.0f;
        float f4 = f2 * 0.55228f;
        float f5 = f3 * 0.55228f;
        this.path.reset();
        if (this.circleShape.isReversed()) {
            this.path.moveTo(0.0f, -f3);
            this.path.cubicTo(0.0f - f4, -f3, -f2, 0.0f - f5, -f2, 0.0f);
            this.path.cubicTo(-f2, 0.0f + f5, 0.0f - f4, f3, 0.0f, f3);
            this.path.cubicTo(0.0f + f4, f3, f2, 0.0f + f5, f2, 0.0f);
            this.path.cubicTo(f2, 0.0f - f5, 0.0f + f4, -f3, 0.0f, -f3);
        } else {
            this.path.moveTo(0.0f, -f3);
            this.path.cubicTo(0.0f + f4, -f3, f2, 0.0f - f5, f2, 0.0f);
            this.path.cubicTo(f2, 0.0f + f5, 0.0f + f4, f3, 0.0f, f3);
            this.path.cubicTo(0.0f - f4, f3, -f2, 0.0f + f5, -f2, 0.0f);
            this.path.cubicTo(-f2, 0.0f - f5, 0.0f - f4, -f3, 0.0f, -f3);
        }
        PointF pointF2 = (PointF)this.positionAnimation.getValue();
        this.path.offset(pointF2.x, pointF2.y);
        this.path.close();
        this.trimPaths.apply(this.path);
        this.isPathValid = true;
        return this.path;
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2) {
        MiscUtils.resolveKeyPath(keyPath, n, list, keyPath2, this);
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        if (object == LottieProperty.ELLIPSE_SIZE) {
            this.sizeAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.POSITION) {
            this.positionAnimation.setValueCallback(lottieValueCallback);
        }
    }
}

