/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.content;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.List;
import oz.lottie.L;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.animation.LPaint;
import oz.lottie.animation.content.Content;
import oz.lottie.animation.content.DrawingContent;
import oz.lottie.animation.content.KeyPathElementContent;
import oz.lottie.animation.content.PathContent;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.animation.keyframe.ColorKeyframeAnimation;
import oz.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import oz.lottie.model.KeyPath;
import oz.lottie.model.content.ShapeFill;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.utils.MiscUtils;
import oz.lottie.value.LottieValueCallback;

public class FillContent
implements DrawingContent,
KeyPathElementContent,
BaseKeyframeAnimation$AnimationListener {
    private final Path path = new Path();
    private final Paint paint = new LPaint(1);
    private final BaseLayer layer;
    private final String name;
    private final boolean hidden;
    private final List paths = new ArrayList();
    private final BaseKeyframeAnimation colorAnimation;
    private final BaseKeyframeAnimation opacityAnimation;
    private BaseKeyframeAnimation colorFilterAnimation;
    private final LottieDrawable lottieDrawable;

    public FillContent(LottieDrawable lottieDrawable, BaseLayer baseLayer, ShapeFill shapeFill) {
        this.layer = baseLayer;
        this.name = shapeFill.getName();
        this.hidden = shapeFill.isHidden();
        this.lottieDrawable = lottieDrawable;
        if (shapeFill.getColor() == null || shapeFill.getOpacity() == null) {
            this.colorAnimation = null;
            this.opacityAnimation = null;
            return;
        }
        this.path.setFillType(shapeFill.getFillType());
        this.colorAnimation = shapeFill.getColor().createAnimation();
        this.colorAnimation.addUpdateListener(this);
        baseLayer.addAnimation(this.colorAnimation);
        this.opacityAnimation = shapeFill.getOpacity().createAnimation();
        this.opacityAnimation.addUpdateListener(this);
        baseLayer.addAnimation(this.opacityAnimation);
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List list, List list2) {
        int n = 0;
        while (n < list2.size()) {
            Content content = (Content)list2.get(n);
            if (content instanceof PathContent) {
                this.paths.add((PathContent)content);
            }
            ++n;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix, int n) {
        if (this.hidden) {
            return;
        }
        L.beginSection("FillContent#draw");
        this.paint.setColor(((ColorKeyframeAnimation)this.colorAnimation).getIntValue());
        int n2 = (int)((float)n / 255.0f * (float)((Integer)this.opacityAnimation.getValue()).intValue() / 100.0f * 255.0f);
        this.paint.setAlpha(MiscUtils.clamp(n2, 0, 255));
        if (this.colorFilterAnimation != null) {
            this.paint.setColorFilter((ColorFilter)this.colorFilterAnimation.getValue());
        }
        this.path.reset();
        int n3 = 0;
        while (n3 < this.paths.size()) {
            this.path.addPath(((PathContent)this.paths.get(n3)).getPath(), matrix);
            ++n3;
        }
        canvas.drawPath(this.path, this.paint);
        L.endSection("FillContent#draw");
    }

    @Override
    public void getBounds(RectF rectF, Matrix matrix, boolean bl) {
        this.path.reset();
        int n = 0;
        while (n < this.paths.size()) {
            this.path.addPath(((PathContent)this.paths.get(n)).getPath(), matrix);
            ++n;
        }
        this.path.computeBounds(rectF, false);
        rectF.set(rectF.left - 1.0f, rectF.top - 1.0f, rectF.right + 1.0f, rectF.bottom + 1.0f);
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2) {
        MiscUtils.resolveKeyPath(keyPath, n, list, keyPath2, this);
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        if (object == LottieProperty.COLOR) {
            this.colorAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.OPACITY) {
            this.opacityAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.COLOR_FILTER) {
            if (lottieValueCallback == null) {
                this.colorFilterAnimation = null;
            } else {
                this.colorFilterAnimation = new ValueCallbackKeyframeAnimation(lottieValueCallback);
                this.colorFilterAnimation.addUpdateListener(this);
                this.layer.addAnimation(this.colorFilterAnimation);
            }
        }
    }
}

