/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.content;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import java.util.List;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.animation.content.CompoundTrimPathContent;
import oz.lottie.animation.content.Content;
import oz.lottie.animation.content.KeyPathElementContent;
import oz.lottie.animation.content.PathContent;
import oz.lottie.animation.content.TrimPathContent;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.animation.keyframe.FloatKeyframeAnimation;
import oz.lottie.model.KeyPath;
import oz.lottie.model.content.RectangleShape;
import oz.lottie.model.content.ShapeTrimPath$Type;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.utils.MiscUtils;
import oz.lottie.value.LottieValueCallback;

public class RectangleContent
implements KeyPathElementContent,
PathContent,
BaseKeyframeAnimation$AnimationListener {
    private final Path path = new Path();
    private final RectF rect = new RectF();
    private final String name;
    private final boolean hidden;
    private final LottieDrawable lottieDrawable;
    private final BaseKeyframeAnimation positionAnimation;
    private final BaseKeyframeAnimation sizeAnimation;
    private final BaseKeyframeAnimation cornerRadiusAnimation;
    private CompoundTrimPathContent trimPaths = new CompoundTrimPathContent();
    private boolean isPathValid;

    public RectangleContent(LottieDrawable lottieDrawable, BaseLayer baseLayer, RectangleShape rectangleShape) {
        this.name = rectangleShape.getName();
        this.hidden = rectangleShape.isHidden();
        this.lottieDrawable = lottieDrawable;
        this.positionAnimation = rectangleShape.getPosition().createAnimation();
        this.sizeAnimation = rectangleShape.getSize().createAnimation();
        this.cornerRadiusAnimation = rectangleShape.getCornerRadius().createAnimation();
        baseLayer.addAnimation(this.positionAnimation);
        baseLayer.addAnimation(this.sizeAnimation);
        baseLayer.addAnimation(this.cornerRadiusAnimation);
        this.positionAnimation.addUpdateListener(this);
        this.sizeAnimation.addUpdateListener(this);
        this.cornerRadiusAnimation.addUpdateListener(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void onValueChanged() {
        this.invalidate();
    }

    private void invalidate() {
        this.isPathValid = false;
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List list, List list2) {
        int n = 0;
        while (n < list.size()) {
            Content content = (Content)list.get(n);
            if (content instanceof TrimPathContent && ((TrimPathContent)content).getType() == ShapeTrimPath$Type.SIMULTANEOUSLY) {
                TrimPathContent trimPathContent = (TrimPathContent)content;
                this.trimPaths.addTrimPath(trimPathContent);
                trimPathContent.addListener(this);
            }
            ++n;
        }
    }

    @Override
    public Path getPath() {
        float f2;
        float f3;
        float f4;
        if (this.isPathValid) {
            return this.path;
        }
        this.path.reset();
        if (this.hidden) {
            this.isPathValid = true;
            return this.path;
        }
        PointF pointF = (PointF)this.sizeAnimation.getValue();
        float f5 = this.cornerRadiusAnimation == null ? 0.0f : ((FloatKeyframeAnimation)this.cornerRadiusAnimation).getFloatValue();
        if (f5 > (f4 = Math.min(f3 = pointF.x / 2.0f, f2 = pointF.y / 2.0f))) {
            f5 = f4;
        }
        PointF pointF2 = (PointF)this.positionAnimation.getValue();
        this.path.moveTo(pointF2.x + f3, pointF2.y - f2 + f5);
        this.path.lineTo(pointF2.x + f3, pointF2.y + f2 - f5);
        if (f5 > 0.0f) {
            this.rect.set(pointF2.x + f3 - 2.0f * f5, pointF2.y + f2 - 2.0f * f5, pointF2.x + f3, pointF2.y + f2);
            this.path.arcTo(this.rect, 0.0f, 90.0f, false);
        }
        this.path.lineTo(pointF2.x - f3 + f5, pointF2.y + f2);
        if (f5 > 0.0f) {
            this.rect.set(pointF2.x - f3, pointF2.y + f2 - 2.0f * f5, pointF2.x - f3 + 2.0f * f5, pointF2.y + f2);
            this.path.arcTo(this.rect, 90.0f, 90.0f, false);
        }
        this.path.lineTo(pointF2.x - f3, pointF2.y - f2 + f5);
        if (f5 > 0.0f) {
            this.rect.set(pointF2.x - f3, pointF2.y - f2, pointF2.x - f3 + 2.0f * f5, pointF2.y - f2 + 2.0f * f5);
            this.path.arcTo(this.rect, 180.0f, 90.0f, false);
        }
        this.path.lineTo(pointF2.x + f3 - f5, pointF2.y - f2);
        if (f5 > 0.0f) {
            this.rect.set(pointF2.x + f3 - 2.0f * f5, pointF2.y - f2, pointF2.x + f3, pointF2.y - f2 + 2.0f * f5);
            this.path.arcTo(this.rect, 270.0f, 90.0f, false);
        }
        this.path.close();
        this.trimPaths.apply(this.path);
        this.isPathValid = true;
        return this.path;
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2) {
        MiscUtils.resolveKeyPath(keyPath, n, list, keyPath2, this);
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        if (object == LottieProperty.RECTANGLE_SIZE) {
            this.sizeAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.POSITION) {
            this.positionAnimation.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.CORNER_RADIUS) {
            this.cornerRadiusAnimation.setValueCallback(lottieValueCallback);
        }
    }
}

