/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import oz.lottie.custom.ArraySet$1;
import oz.lottie.custom.ContainerHelpers;
import oz.lottie.custom.MapCollections;

public final class ArraySet
implements Collection,
Set {
    private static final boolean DEBUG = false;
    private static final String TAG = "ArraySet";
    private static final int[] INT = new int[0];
    private static final Object[] OBJECT = new Object[0];
    private static final int BASE_SIZE = 4;
    private static final int CACHE_SIZE = 10;
    private static Object[] sBaseCache;
    private static int sBaseCacheSize;
    private static Object[] sTwiceBaseCache;
    private static int sTwiceBaseCacheSize;
    private int[] mHashes;
    Object[] mArray;
    int mSize;
    private MapCollections mCollections;

    private int indexOf(Object object, int n) {
        int n2 = this.mSize;
        if (n2 == 0) {
            return -1;
        }
        int n3 = ContainerHelpers.binarySearch(this.mHashes, n2, n);
        if (n3 < 0) {
            return n3;
        }
        if (object.equals(this.mArray[n3])) {
            return n3;
        }
        int n4 = n3 + 1;
        while (n4 < n2 && this.mHashes[n4] == n) {
            if (object.equals(this.mArray[n4])) {
                return n4;
            }
            ++n4;
        }
        int n5 = n3 - 1;
        while (n5 >= 0 && this.mHashes[n5] == n) {
            if (object.equals(this.mArray[n5])) {
                return n5;
            }
            --n5;
        }
        return ~n4;
    }

    private int indexOfNull() {
        int n = this.mSize;
        if (n == 0) {
            return -1;
        }
        int n2 = ContainerHelpers.binarySearch(this.mHashes, n, 0);
        if (n2 < 0) {
            return n2;
        }
        if (this.mArray[n2] == null) {
            return n2;
        }
        int n3 = n2 + 1;
        while (n3 < n && this.mHashes[n3] == 0) {
            if (this.mArray[n3] == null) {
                return n3;
            }
            ++n3;
        }
        int n4 = n2 - 1;
        while (n4 >= 0 && this.mHashes[n4] == 0) {
            if (this.mArray[n4] == null) {
                return n4;
            }
            --n4;
        }
        return ~n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void allocArrays(int n) {
        if (n == 8) {
            Class<ArraySet> clazz = ArraySet.class;
            // MONITORENTER : oz.lottie.custom.ArraySet.class
            if (sTwiceBaseCache != null) {
                Object[] objectArray = sTwiceBaseCache;
                this.mArray = objectArray;
                sTwiceBaseCache = (Object[])objectArray[0];
                this.mHashes = (int[])objectArray[1];
                objectArray[1] = null;
                objectArray[0] = null;
                --sTwiceBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        if (n == 4) {
            Class<ArraySet> clazz = ArraySet.class;
            // MONITORENTER : oz.lottie.custom.ArraySet.class
            if (sBaseCache != null) {
                Object[] objectArray = sBaseCache;
                this.mArray = objectArray;
                sBaseCache = (Object[])objectArray[0];
                this.mHashes = (int[])objectArray[1];
                objectArray[1] = null;
                objectArray[0] = null;
                --sBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        this.mHashes = new int[n];
        this.mArray = new Object[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void freeArrays(int[] nArray, Object[] objectArray, int n) {
        if (nArray.length == 8) {
            Class<ArraySet> clazz = ArraySet.class;
            synchronized (ArraySet.class) {
                if (sTwiceBaseCacheSize >= 10) return;
                objectArray[0] = sTwiceBaseCache;
                objectArray[1] = nArray;
                int n2 = n - 1;
                while (n2 >= 2) {
                    objectArray[n2] = null;
                    --n2;
                }
                sTwiceBaseCache = objectArray;
                ++sTwiceBaseCacheSize;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
        if (nArray.length != 4) return;
        Class<ArraySet> clazz = ArraySet.class;
        synchronized (ArraySet.class) {
            if (sBaseCacheSize >= 10) return;
            objectArray[0] = sBaseCache;
            objectArray[1] = nArray;
            int n3 = n - 1;
            while (n3 >= 2) {
                objectArray[n3] = null;
                --n3;
            }
            sBaseCache = objectArray;
            ++sBaseCacheSize;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public ArraySet() {
        this(0);
    }

    public ArraySet(int n) {
        if (n == 0) {
            this.mHashes = INT;
            this.mArray = OBJECT;
        } else {
            this.allocArrays(n);
        }
        this.mSize = 0;
    }

    public ArraySet(ArraySet arraySet) {
        this();
        if (arraySet != null) {
            this.addAll(arraySet);
        }
    }

    public ArraySet(Collection collection) {
        this();
        if (collection != null) {
            this.addAll(collection);
        }
    }

    @Override
    public void clear() {
        if (this.mSize != 0) {
            ArraySet.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = INT;
            this.mArray = OBJECT;
            this.mSize = 0;
        }
    }

    public void ensureCapacity(int n) {
        if (this.mHashes.length < n) {
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n);
            if (this.mSize > 0) {
                System.arraycopy(nArray, 0, this.mHashes, 0, this.mSize);
                System.arraycopy(objectArray, 0, this.mArray, 0, this.mSize);
            }
            ArraySet.freeArrays(nArray, objectArray, this.mSize);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public int indexOf(Object object) {
        return object == null ? this.indexOfNull() : this.indexOf(object, object.hashCode());
    }

    public Object valueAt(int n) {
        return this.mArray[n];
    }

    @Override
    public boolean isEmpty() {
        return this.mSize <= 0;
    }

    @Override
    public boolean add(Object object) {
        int n;
        int n2;
        if (object == null) {
            n2 = 0;
            n = this.indexOfNull();
        } else {
            n2 = object.hashCode();
            n = this.indexOf(object, n2);
        }
        if (n >= 0) {
            return false;
        }
        n ^= 0xFFFFFFFF;
        if (this.mSize >= this.mHashes.length) {
            int n3 = this.mSize >= 8 ? this.mSize + (this.mSize >> 1) : (this.mSize >= 4 ? 8 : 4);
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n3);
            if (this.mHashes.length > 0) {
                System.arraycopy(nArray, 0, this.mHashes, 0, nArray.length);
                System.arraycopy(objectArray, 0, this.mArray, 0, objectArray.length);
            }
            ArraySet.freeArrays(nArray, objectArray, this.mSize);
        }
        if (n < this.mSize) {
            System.arraycopy(this.mHashes, n, this.mHashes, n + 1, this.mSize - n);
            System.arraycopy(this.mArray, n, this.mArray, n + 1, this.mSize - n);
        }
        this.mHashes[n] = n2;
        this.mArray[n] = object;
        ++this.mSize;
        return true;
    }

    public void append(Object object) {
        int n;
        int n2 = this.mSize;
        int n3 = n = object == null ? 0 : object.hashCode();
        if (n2 >= this.mHashes.length) {
            throw new IllegalStateException("Array is full");
        }
        if (n2 > 0 && this.mHashes[n2 - 1] > n) {
            this.add(object);
            return;
        }
        this.mSize = n2 + 1;
        this.mHashes[n2] = n;
        this.mArray[n2] = object;
    }

    public void addAll(ArraySet arraySet) {
        int n = arraySet.mSize;
        this.ensureCapacity(this.mSize + n);
        if (this.mSize == 0) {
            if (n > 0) {
                System.arraycopy(arraySet.mHashes, 0, this.mHashes, 0, n);
                System.arraycopy(arraySet.mArray, 0, this.mArray, 0, n);
                this.mSize = n;
            }
        } else {
            int n2 = 0;
            while (n2 < n) {
                this.add(arraySet.valueAt(n2));
                ++n2;
            }
        }
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeAt(n);
            return true;
        }
        return false;
    }

    public Object removeAt(int n) {
        Object object = this.mArray[n];
        if (this.mSize <= 1) {
            ArraySet.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = INT;
            this.mArray = OBJECT;
            this.mSize = 0;
        } else if (this.mHashes.length > 8 && this.mSize < this.mHashes.length / 3) {
            int n2 = this.mSize > 8 ? this.mSize + (this.mSize >> 1) : 8;
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n2);
            --this.mSize;
            if (n > 0) {
                System.arraycopy(nArray, 0, this.mHashes, 0, n);
                System.arraycopy(objectArray, 0, this.mArray, 0, n);
            }
            if (n < this.mSize) {
                System.arraycopy(nArray, n + 1, this.mHashes, n, this.mSize - n);
                System.arraycopy(objectArray, n + 1, this.mArray, n, this.mSize - n);
            }
        } else {
            --this.mSize;
            if (n < this.mSize) {
                System.arraycopy(this.mHashes, n + 1, this.mHashes, n, this.mSize - n);
                System.arraycopy(this.mArray, n + 1, this.mArray, n, this.mSize - n);
            }
            this.mArray[this.mSize] = null;
        }
        return object;
    }

    public boolean removeAll(ArraySet arraySet) {
        int n = arraySet.mSize;
        int n2 = this.mSize;
        int n3 = 0;
        while (n3 < n) {
            this.remove(arraySet.valueAt(n3));
            ++n3;
        }
        return n2 != this.mSize;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.mSize];
        System.arraycopy(this.mArray, 0, objectArray, 0, this.mSize);
        return objectArray;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.mSize) {
            Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.mSize);
            objectArray = objectArray2;
        }
        System.arraycopy(this.mArray, 0, objectArray, 0, this.mSize);
        if (objectArray.length > this.mSize) {
            objectArray[this.mSize] = null;
        }
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) return false;
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        try {
            int n = 0;
            while (true) {
                if (n >= this.mSize) {
                    return true;
                }
                Object object2 = this.valueAt(n);
                if (!set.contains(object2)) {
                    return false;
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int[] nArray = this.mHashes;
        int n = 0;
        int n2 = 0;
        int n3 = this.mSize;
        while (n2 < n3) {
            n += nArray[n2];
            ++n2;
        }
        return n;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(this.mSize * 14);
        stringBuilder.append('{');
        int n = 0;
        while (n < this.mSize) {
            Object object;
            if (n > 0) {
                stringBuilder.append(", ");
            }
            if ((object = this.valueAt(n)) != this) {
                stringBuilder.append(object);
            } else {
                stringBuilder.append("(this Set)");
            }
            ++n;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private MapCollections getCollection() {
        if (this.mCollections == null) {
            this.mCollections = new ArraySet$1(this);
        }
        return this.mCollections;
    }

    @Override
    public Iterator iterator() {
        return this.getCollection().getKeySet().iterator();
    }

    @Override
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        this.ensureCapacity(this.mSize + collection.size());
        boolean bl = false;
        for (Object e2 : collection) {
            bl |= this.add(e2);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean bl = false;
        for (Object e2 : collection) {
            bl |= this.remove(e2);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean bl = false;
        int n = this.mSize - 1;
        while (n >= 0) {
            if (!collection.contains(this.mArray[n])) {
                this.removeAt(n);
                bl = true;
            }
            --n;
        }
        return bl;
    }
}

