/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oz.lottie.model.KeyPathElement;

public class KeyPath {
    private final List keys;
    private KeyPathElement resolvedElement;

    public KeyPath(String ... stringArray) {
        this.keys = Arrays.asList(stringArray);
    }

    private KeyPath(KeyPath keyPath) {
        this.keys = new ArrayList(keyPath.keys);
        this.resolvedElement = keyPath.resolvedElement;
    }

    public KeyPath addKey(String string) {
        KeyPath keyPath = new KeyPath(this);
        keyPath.keys.add(string);
        return keyPath;
    }

    public KeyPath resolve(KeyPathElement keyPathElement) {
        KeyPath keyPath = new KeyPath(this);
        keyPath.resolvedElement = keyPathElement;
        return keyPath;
    }

    public KeyPathElement getResolvedElement() {
        return this.resolvedElement;
    }

    public boolean matches(String string, int n) {
        if (this.isContainer(string)) {
            return true;
        }
        if (n >= this.keys.size()) {
            return false;
        }
        return ((String)this.keys.get(n)).equals(string) || ((String)this.keys.get(n)).equals("**") || ((String)this.keys.get(n)).equals("*");
    }

    public int incrementDepthBy(String string, int n) {
        if (this.isContainer(string)) {
            return 0;
        }
        if (!((String)this.keys.get(n)).equals("**")) {
            return 1;
        }
        if (n == this.keys.size() - 1) {
            return 0;
        }
        if (((String)this.keys.get(n + 1)).equals(string)) {
            return 2;
        }
        return 0;
    }

    public boolean fullyResolvesTo(String string, int n) {
        boolean bl;
        if (n >= this.keys.size()) {
            return false;
        }
        boolean bl2 = n == this.keys.size() - 1;
        String string2 = (String)this.keys.get(n);
        boolean bl3 = string2.equals("**");
        if (!bl3) {
            boolean bl4;
            boolean bl5 = bl4 = string2.equals(string) || string2.equals("*");
            return (bl2 || n == this.keys.size() - 2 && this.endsWithGlobstar()) && bl4;
        }
        boolean bl6 = bl = !bl2 && ((String)this.keys.get(n + 1)).equals(string);
        if (bl) {
            return n == this.keys.size() - 2 || n == this.keys.size() - 3 && this.endsWithGlobstar();
        }
        if (bl2) {
            return true;
        }
        if (n + 1 < this.keys.size() - 1) {
            return false;
        }
        return ((String)this.keys.get(n + 1)).equals(string);
    }

    public boolean propagateToChildren(String string, int n) {
        if ("__container".equals(string)) {
            return true;
        }
        return n < this.keys.size() - 1 || ((String)this.keys.get(n)).equals("**");
    }

    private boolean isContainer(String string) {
        return "__container".equals(string);
    }

    private boolean endsWithGlobstar() {
        return ((String)this.keys.get(this.keys.size() - 1)).equals("**");
    }

    public String keysToString() {
        return this.keys.toString();
    }

    public String toString() {
        return "KeyPath{keys=" + this.keys + ",resolved=" + (this.resolvedElement != null) + '}';
    }
}

