/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import android.graphics.PointF;
import oz.lottie.LottieComposition;
import oz.lottie.model.animatable.AnimatableFloatValue;
import oz.lottie.model.animatable.AnimatableIntegerValue;
import oz.lottie.model.animatable.AnimatablePathValue;
import oz.lottie.model.animatable.AnimatableScaleValue;
import oz.lottie.model.animatable.AnimatableSplitDimensionPathValue;
import oz.lottie.model.animatable.AnimatableTransform;
import oz.lottie.model.animatable.AnimatableValue;
import oz.lottie.parser.AnimatablePathValueParser;
import oz.lottie.parser.AnimatableValueParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;
import oz.lottie.parser.moshi.JsonReader$Token;
import oz.lottie.value.Keyframe;
import oz.lottie.value.ScaleXY;

public class AnimatableTransformParser {
    private static JsonReader$Options NAMES = JsonReader$Options.of("a", "p", "s", "rz", "r", "o", "so", "eo", "sk", "sa");
    private static JsonReader$Options ANIMATABLE_NAMES = JsonReader$Options.of("k");

    private AnimatableTransformParser() {
    }

    public static AnimatableTransform parse(JsonReader jsonReader, LottieComposition lottieComposition) {
        boolean bl;
        AnimatablePathValue animatablePathValue = null;
        AnimatableValue animatableValue = null;
        AnimatableScaleValue animatableScaleValue = null;
        AnimatableFloatValue animatableFloatValue = null;
        AnimatableIntegerValue animatableIntegerValue = null;
        AnimatableFloatValue animatableFloatValue2 = null;
        AnimatableFloatValue animatableFloatValue3 = null;
        AnimatableFloatValue animatableFloatValue4 = null;
        AnimatableFloatValue animatableFloatValue5 = null;
        boolean bl2 = bl = jsonReader.peek() == JsonReader$Token.BEGIN_OBJECT;
        if (bl) {
            jsonReader.beginObject();
        }
        block15: while (jsonReader.hasNext()) {
            switch (jsonReader.selectName(NAMES)) {
                case 0: {
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        switch (jsonReader.selectName(ANIMATABLE_NAMES)) {
                            case 0: {
                                animatablePathValue = AnimatablePathValueParser.parse(jsonReader, lottieComposition);
                                break;
                            }
                            default: {
                                jsonReader.skipName();
                                jsonReader.skipValue();
                            }
                        }
                    }
                    jsonReader.endObject();
                    break;
                }
                case 1: {
                    animatableValue = AnimatablePathValueParser.parseSplitPath(jsonReader, lottieComposition);
                    break;
                }
                case 2: {
                    animatableScaleValue = AnimatableValueParser.parseScale(jsonReader, lottieComposition);
                    break;
                }
                case 3: {
                    lottieComposition.addWarning("Lottie doesn't support 3D layers.");
                }
                case 4: {
                    animatableFloatValue = AnimatableValueParser.parseFloat(jsonReader, lottieComposition, false);
                    if (animatableFloatValue.getKeyframes().isEmpty()) {
                        animatableFloatValue.getKeyframes().add(new Keyframe(lottieComposition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(lottieComposition.getEndFrame())));
                        break;
                    }
                    if (((Keyframe)animatableFloatValue.getKeyframes().get((int)0)).startValue != null) continue block15;
                    animatableFloatValue.getKeyframes().set(0, new Keyframe(lottieComposition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(lottieComposition.getEndFrame())));
                    break;
                }
                case 5: {
                    animatableIntegerValue = AnimatableValueParser.parseInteger(jsonReader, lottieComposition);
                    break;
                }
                case 6: {
                    animatableFloatValue2 = AnimatableValueParser.parseFloat(jsonReader, lottieComposition, false);
                    break;
                }
                case 7: {
                    animatableFloatValue3 = AnimatableValueParser.parseFloat(jsonReader, lottieComposition, false);
                    break;
                }
                case 8: {
                    animatableFloatValue4 = AnimatableValueParser.parseFloat(jsonReader, lottieComposition, false);
                    break;
                }
                case 9: {
                    animatableFloatValue5 = AnimatableValueParser.parseFloat(jsonReader, lottieComposition, false);
                    break;
                }
                default: {
                    jsonReader.skipName();
                    jsonReader.skipValue();
                }
            }
        }
        if (bl) {
            jsonReader.endObject();
        }
        if (AnimatableTransformParser.isAnchorPointIdentity(animatablePathValue)) {
            animatablePathValue = null;
        }
        if (AnimatableTransformParser.isPositionIdentity(animatableValue)) {
            animatableValue = null;
        }
        if (AnimatableTransformParser.isRotationIdentity(animatableFloatValue)) {
            animatableFloatValue = null;
        }
        if (AnimatableTransformParser.isScaleIdentity(animatableScaleValue)) {
            animatableScaleValue = null;
        }
        if (AnimatableTransformParser.isSkewIdentity(animatableFloatValue4)) {
            animatableFloatValue4 = null;
        }
        if (AnimatableTransformParser.isSkewAngleIdentity(animatableFloatValue5)) {
            animatableFloatValue5 = null;
        }
        return new AnimatableTransform(animatablePathValue, animatableValue, animatableScaleValue, animatableFloatValue, animatableIntegerValue, animatableFloatValue2, animatableFloatValue3, animatableFloatValue4, animatableFloatValue5);
    }

    private static boolean isAnchorPointIdentity(AnimatablePathValue animatablePathValue) {
        return animatablePathValue == null || animatablePathValue.isStatic() && ((PointF)((Keyframe)animatablePathValue.getKeyframes().get((int)0)).startValue).equals(0.0f, 0.0f);
    }

    private static boolean isPositionIdentity(AnimatableValue animatableValue) {
        return animatableValue == null || !(animatableValue instanceof AnimatableSplitDimensionPathValue) && animatableValue.isStatic() && ((PointF)((Keyframe)animatableValue.getKeyframes().get((int)0)).startValue).equals(0.0f, 0.0f);
    }

    private static boolean isRotationIdentity(AnimatableFloatValue animatableFloatValue) {
        return animatableFloatValue == null || animatableFloatValue.isStatic() && ((Float)((Keyframe)animatableFloatValue.getKeyframes().get((int)0)).startValue).floatValue() == 0.0f;
    }

    private static boolean isScaleIdentity(AnimatableScaleValue animatableScaleValue) {
        return animatableScaleValue == null || animatableScaleValue.isStatic() && ((ScaleXY)((Keyframe)animatableScaleValue.getKeyframes().get((int)0)).startValue).equals(1.0f, 1.0f);
    }

    private static boolean isSkewIdentity(AnimatableFloatValue animatableFloatValue) {
        return animatableFloatValue == null || animatableFloatValue.isStatic() && ((Float)((Keyframe)animatableFloatValue.getKeyframes().get((int)0)).startValue).floatValue() == 0.0f;
    }

    private static boolean isSkewAngleIdentity(AnimatableFloatValue animatableFloatValue) {
        return animatableFloatValue == null || animatableFloatValue.isStatic() && ((Float)((Keyframe)animatableFloatValue.getKeyframes().get((int)0)).startValue).floatValue() == 0.0f;
    }
}

