/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.utils;

import android.graphics.Path;
import android.graphics.PointF;
import java.util.List;
import oz.lottie.animation.content.KeyPathElementContent;
import oz.lottie.model.CubicCurveData;
import oz.lottie.model.KeyPath;
import oz.lottie.model.content.ShapeData;

public class MiscUtils {
    private static PointF pathFromDataCurrentPoint = new PointF();

    public static PointF addPoints(PointF pointF, PointF pointF2) {
        return new PointF(pointF.x + pointF2.x, pointF.y + pointF2.y);
    }

    public static void getPathFromData(ShapeData shapeData, Path path) {
        path.reset();
        PointF pointF = shapeData.getInitialPoint();
        path.moveTo(pointF.x, pointF.y);
        pathFromDataCurrentPoint.set(pointF.x, pointF.y);
        int n = 0;
        while (n < shapeData.getCurves().size()) {
            CubicCurveData cubicCurveData = (CubicCurveData)shapeData.getCurves().get(n);
            PointF pointF2 = cubicCurveData.getControlPoint1();
            PointF pointF3 = cubicCurveData.getControlPoint2();
            PointF pointF4 = cubicCurveData.getVertex();
            if (pointF2.equals((Object)pathFromDataCurrentPoint) && pointF3.equals((Object)pointF4)) {
                path.lineTo(pointF4.x, pointF4.y);
            } else {
                path.cubicTo(pointF2.x, pointF2.y, pointF3.x, pointF3.y, pointF4.x, pointF4.y);
            }
            pathFromDataCurrentPoint.set(pointF4.x, pointF4.y);
            ++n;
        }
        if (shapeData.isClosed()) {
            path.close();
        }
    }

    public static float lerp(float f2, float f3, float f4) {
        return f2 + f4 * (f3 - f2);
    }

    public static double lerp(double d2, double d3, double d4) {
        return d2 + d4 * (d3 - d2);
    }

    public static int lerp(int n, int n2, float f2) {
        return (int)((float)n + f2 * (float)(n2 - n));
    }

    static int floorMod(float f2, float f3) {
        return MiscUtils.floorMod((int)f2, (int)f3);
    }

    private static int floorMod(int n, int n2) {
        return n - n2 * MiscUtils.floorDiv(n, n2);
    }

    private static int floorDiv(int n, int n2) {
        int n3 = n / n2;
        boolean bl = (n ^ n2) >= 0;
        int n4 = n % n2;
        if (!bl && n4 != 0) {
            --n3;
        }
        return n3;
    }

    public static int clamp(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n3, n));
    }

    public static float clamp(float f2, float f3, float f4) {
        return Math.max(f3, Math.min(f4, f2));
    }

    public static boolean contains(float f2, float f3, float f4) {
        return f2 >= f3 && f2 <= f4;
    }

    public static void resolveKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2, KeyPathElementContent keyPathElementContent) {
        if (keyPath.fullyResolvesTo(keyPathElementContent.getName(), n)) {
            keyPath2 = keyPath2.addKey(keyPathElementContent.getName());
            list.add(keyPath2.resolve(keyPathElementContent));
        }
    }
}

