/*
 * Decompiled with CFR 0.152.
 */
package oz.materialcalendarview;

import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.LocalDate;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.WeekFields;
import oz.materialcalendarview.CalendarDay;
import oz.materialcalendarview.CalendarPagerView$LayoutParams;
import oz.materialcalendarview.DayView;
import oz.materialcalendarview.DayViewFacade;
import oz.materialcalendarview.DecoratorResult;
import oz.materialcalendarview.LocalUtils;
import oz.materialcalendarview.MaterialCalendarView;
import oz.materialcalendarview.WeekDayView;
import oz.materialcalendarview.format.DayFormatter;
import oz.materialcalendarview.format.WeekDayFormatter;

abstract class CalendarPagerView
extends ViewGroup
implements View.OnClickListener,
View.OnLongClickListener {
    protected static final int DEFAULT_DAYS_IN_WEEK = 7;
    protected static final int DEFAULT_MAX_WEEKS = 6;
    protected static final int DAY_NAMES_ROW = 1;
    private final ArrayList weekDayViews = new ArrayList();
    private final ArrayList decoratorResults = new ArrayList();
    private final DayOfWeek firstDayOfWeek;
    protected int showOtherDates = 4;
    private MaterialCalendarView mcv;
    private CalendarDay firstViewDay;
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    protected boolean showWeekDays;
    private final Collection dayViews = new ArrayList();

    public CalendarPagerView(MaterialCalendarView materialCalendarView, CalendarDay calendarDay, DayOfWeek dayOfWeek, boolean bl) {
        super(materialCalendarView.getContext());
        this.mcv = materialCalendarView;
        this.firstViewDay = calendarDay;
        this.firstDayOfWeek = dayOfWeek;
        this.showWeekDays = bl;
        this.setClipChildren(false);
        this.setClipToPadding(false);
        if (bl) {
            this.buildWeekDays(this.resetAndGetWorkingCalendar());
        }
        this.buildDayViews(this.dayViews, this.resetAndGetWorkingCalendar());
    }

    private void buildWeekDays(LocalDate localDate) {
        LocalDate localDate2 = localDate;
        for (int j = 0; j < 7; ++j) {
            WeekDayView weekDayView = new WeekDayView(this.getContext(), localDate2.getDayOfWeek());
            if (Build.VERSION.SDK_INT >= 16) {
                weekDayView.setImportantForAccessibility(2);
            }
            this.weekDayViews.add(weekDayView);
            this.addView((View)weekDayView);
            localDate2 = localDate2.plusDays(1L);
        }
    }

    protected void addDayView(Collection collection, LocalDate localDate) {
        CalendarDay calendarDay = CalendarDay.from(localDate);
        DayView dayView = new DayView(this.getContext(), calendarDay);
        dayView.setOnClickListener(this);
        dayView.setOnLongClickListener(this);
        collection.add(dayView);
        this.addView((View)dayView, (ViewGroup.LayoutParams)new CalendarPagerView$LayoutParams());
    }

    protected LocalDate resetAndGetWorkingCalendar() {
        boolean bl;
        TemporalField temporalField = WeekFields.of((DayOfWeek)this.firstDayOfWeek, (int)1).dayOfWeek();
        LocalDate localDate = this.getFirstViewDay().getDate().with(temporalField, 1L);
        int n = localDate.getDayOfWeek().getValue();
        int n2 = this.getFirstDayOfWeek().getValue() - n;
        boolean bl2 = MaterialCalendarView.showOtherMonths(this.showOtherDates) ? n2 >= 0 : (bl = n2 > 0);
        if (bl) {
            n2 -= 7;
        }
        return localDate.plusDays((long)n2);
    }

    protected DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    protected abstract void buildDayViews(Collection var1, LocalDate var2);

    protected abstract boolean isDayEnabled(CalendarDay var1);

    void setDayViewDecorators(List list) {
        this.decoratorResults.clear();
        if (list != null) {
            this.decoratorResults.addAll(list);
        }
        this.invalidateDecorators();
    }

    public void setWeekDayTextAppearance(int n) {
        for (WeekDayView weekDayView : this.weekDayViews) {
            weekDayView.setTextAppearance(this.getContext(), n);
        }
    }

    public void setDateTextAppearance(int n) {
        for (DayView dayView : this.dayViews) {
            dayView.setTextAppearance(this.getContext(), n);
        }
    }

    public void setShowOtherDates(int n) {
        this.showOtherDates = n;
        this.updateUi();
    }

    public void setSelectionEnabled(boolean bl) {
        for (DayView dayView : this.dayViews) {
            dayView.setOnClickListener(bl ? this : null);
            dayView.setClickable(bl);
        }
    }

    public void setSelectionColor(int n) {
        for (DayView dayView : this.dayViews) {
            dayView.setSelectionColor(n);
        }
    }

    public void setWeekDayFormatter(WeekDayFormatter weekDayFormatter) {
        for (WeekDayView weekDayView : this.weekDayViews) {
            weekDayView.setWeekDayFormatter(weekDayFormatter);
        }
    }

    public void setDayFormatter(DayFormatter dayFormatter) {
        for (DayView dayView : this.dayViews) {
            dayView.setDayFormatter(dayFormatter);
        }
    }

    public void setDayFormatterContentDescription(DayFormatter dayFormatter) {
        for (DayView dayView : this.dayViews) {
            dayView.setDayFormatterContentDescription(dayFormatter);
        }
    }

    public void setMinimumDate(CalendarDay calendarDay) {
        this.minDate = calendarDay;
        this.updateUi();
    }

    public void setMaximumDate(CalendarDay calendarDay) {
        this.maxDate = calendarDay;
        this.updateUi();
    }

    public void setSelectedDates(Collection collection) {
        for (DayView dayView : this.dayViews) {
            CalendarDay calendarDay = dayView.getDate();
            dayView.setChecked(collection != null && collection.contains(calendarDay));
        }
        this.postInvalidate();
    }

    protected void updateUi() {
        for (DayView dayView : this.dayViews) {
            CalendarDay calendarDay = dayView.getDate();
            dayView.setupSelection(this.showOtherDates, calendarDay.isInRange(this.minDate, this.maxDate), this.isDayEnabled(calendarDay));
        }
        this.postInvalidate();
    }

    protected void invalidateDecorators() {
        DayViewFacade dayViewFacade = new DayViewFacade();
        for (DayView dayView : this.dayViews) {
            dayViewFacade.reset();
            for (DecoratorResult decoratorResult : this.decoratorResults) {
                if (!decoratorResult.decorator.shouldDecorate(dayView.getDate())) continue;
                decoratorResult.result.applyTo(dayViewFacade);
            }
            dayView.applyFacade(dayViewFacade);
        }
    }

    public void onClick(View view) {
        if (view instanceof DayView) {
            DayView dayView = (DayView)view;
            this.mcv.onDateClicked(dayView);
        }
    }

    public boolean onLongClick(View view) {
        if (view instanceof DayView) {
            DayView dayView = (DayView)view;
            this.mcv.onDateLongClicked(dayView);
            return true;
        }
        return false;
    }

    protected CalendarPagerView$LayoutParams generateDefaultLayoutParams() {
        return new CalendarPagerView$LayoutParams();
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getMode((int)n);
        int n5 = View.MeasureSpec.getSize((int)n2);
        int n6 = View.MeasureSpec.getMode((int)n2);
        if (n6 == 0 || n4 == 0) {
            throw new IllegalStateException("CalendarPagerView should never be left to decide it's size");
        }
        int n7 = n3 / 7;
        int n8 = n5 / this.getRows();
        this.setMeasuredDimension(n3, n5);
        int n9 = this.getChildCount();
        for (int j = 0; j < n9; ++j) {
            View view = this.getChildAt(j);
            int n10 = View.MeasureSpec.makeMeasureSpec((int)n7, (int)0x40000000);
            int n11 = View.MeasureSpec.makeMeasureSpec((int)n8, (int)0x40000000);
            view.measure(n10, n11);
        }
    }

    protected abstract int getRows();

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getWidth();
        int n6 = this.getChildCount();
        boolean bl2 = false;
        int n7 = n5;
        int n8 = 0;
        int n9 = 0;
        int n10 = n7;
        for (int j = 0; j < n6; ++j) {
            View view = this.getChildAt(j);
            int n11 = view.getMeasuredWidth();
            int n12 = view.getMeasuredHeight();
            if (LocalUtils.isRTL()) {
                view.layout(n10 - n11, n8, n10, n8 + n12);
                n10 -= n11;
            } else {
                view.layout(n9, n8, n9 + n11, n8 + n12);
                n9 += n11;
            }
            if (j % 7 != 6) continue;
            n9 = 0;
            n10 = n7;
            n8 += n12;
        }
    }

    public CalendarPagerView$LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new CalendarPagerView$LayoutParams();
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof CalendarPagerView$LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new CalendarPagerView$LayoutParams();
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)CalendarPagerView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)CalendarPagerView.class.getName());
    }

    protected CalendarDay getFirstViewDay() {
        return this.firstViewDay;
    }
}

