/*
 * Decompiled with CFR 0.152.
 */
package oz.materialcalendarview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.text.SpannableString;
import android.text.Spanned;
import android.widget.CheckedTextView;
import java.util.List;
import org.threeten.bp.DayOfWeek;
import oz.materialcalendarview.CalendarDay;
import oz.materialcalendarview.DayViewFacade;
import oz.materialcalendarview.DayViewFacade$Span;
import oz.materialcalendarview.MaterialCalendarView;
import oz.materialcalendarview.format.DayFormatter;

class DayView
extends CheckedTextView {
    private CalendarDay date;
    private int selectionColor = -7829368;
    private final int fadeTime;
    private Drawable customBackground = null;
    private Drawable selectionDrawable;
    private Drawable mCircleDrawable;
    private DayFormatter formatter;
    private DayFormatter contentDescriptionFormatter = this.formatter = DayFormatter.DEFAULT;
    private boolean isInRange = true;
    private boolean isInMonth = true;
    private boolean isDecoratedDisabled = false;
    private int showOtherDates = 4;
    private final Rect tempRect = new Rect();
    private final Rect circleDrawableRect = new Rect();

    public DayView(Context context, CalendarDay calendarDay) {
        super(context);
        this.fadeTime = this.getResources().getInteger(0x10E0000);
        this.setSelectionColor(this.selectionColor);
        this.setGravity(17);
        if (Build.VERSION.SDK_INT >= 17) {
            this.setTextAlignment(4);
        }
        this.setDay(calendarDay);
    }

    public void setDay(CalendarDay calendarDay) {
        this.date = calendarDay;
        this.setText(this.getLabel());
        this.setTextColor(-16711936);
        if (calendarDay.getDate().getDayOfWeek() == DayOfWeek.SUNDAY) {
            this.setTextColor(-41364);
        } else if (calendarDay.getDate().getDayOfWeek() == DayOfWeek.SATURDAY) {
            this.setTextColor(-15891969);
        } else {
            this.setTextColor(-1);
        }
    }

    public void setDayFormatter(DayFormatter dayFormatter) {
        this.contentDescriptionFormatter = this.contentDescriptionFormatter == this.formatter ? dayFormatter : this.contentDescriptionFormatter;
        this.formatter = dayFormatter == null ? DayFormatter.DEFAULT : dayFormatter;
        CharSequence charSequence = this.getText();
        Object[] objectArray = null;
        if (charSequence instanceof Spanned) {
            objectArray = ((Spanned)charSequence).getSpans(0, charSequence.length(), Object.class);
        }
        SpannableString spannableString = new SpannableString((CharSequence)this.getLabel());
        if (objectArray != null) {
            for (Object object : objectArray) {
                spannableString.setSpan(object, 0, spannableString.length(), 33);
            }
        }
        this.setText((CharSequence)spannableString);
    }

    public void setDayFormatterContentDescription(DayFormatter dayFormatter) {
        this.contentDescriptionFormatter = dayFormatter == null ? this.formatter : dayFormatter;
        this.setContentDescription(this.getContentDescriptionLabel());
    }

    public String getLabel() {
        return this.formatter.format(this.date);
    }

    public String getContentDescriptionLabel() {
        return this.contentDescriptionFormatter == null ? this.formatter.format(this.date) : this.contentDescriptionFormatter.format(this.date);
    }

    public void setSelectionColor(int n) {
        this.selectionColor = n;
        this.regenerateBackground();
    }

    public void setSelectionDrawable(Drawable drawable2) {
        this.selectionDrawable = drawable2 == null ? null : drawable2.getConstantState().newDrawable(this.getResources());
        this.regenerateBackground();
    }

    public void setCustomBackground(Drawable drawable2) {
        this.customBackground = drawable2 == null ? null : drawable2.getConstantState().newDrawable(this.getResources());
        this.invalidate();
    }

    public CalendarDay getDate() {
        return this.date;
    }

    private void setEnabled() {
        boolean bl = this.isInMonth && this.isInRange && !this.isDecoratedDisabled;
        super.setEnabled(this.isInRange && !this.isDecoratedDisabled);
        boolean bl2 = MaterialCalendarView.showOtherMonths(this.showOtherDates);
        boolean bl3 = MaterialCalendarView.showOutOfRange(this.showOtherDates) || bl2;
        boolean bl4 = MaterialCalendarView.showDecoratedDisabled(this.showOtherDates);
        boolean bl5 = bl;
        if (!this.isInMonth && bl2) {
            bl5 = true;
            this.setTextColor(-7829368);
        }
        if (!this.isInRange && bl3) {
            bl5 |= this.isInMonth;
        }
        if (this.isDecoratedDisabled && bl4) {
            bl5 |= this.isInMonth && this.isInRange;
        }
        if (!this.isInMonth && bl5) {
            this.setTextColor(this.getTextColors().getColorForState(new int[]{-16842910}, -7829368));
        }
        this.setVisibility(bl5 ? 0 : 4);
    }

    protected void setupSelection(int n, boolean bl, boolean bl2) {
        this.showOtherDates = n;
        this.isInMonth = bl2;
        this.isInRange = bl;
        this.setEnabled();
    }

    protected void onDraw(Canvas canvas) {
        if (this.customBackground != null) {
            this.customBackground.setBounds(this.tempRect);
            this.customBackground.setState(this.getDrawableState());
            this.customBackground.draw(canvas);
        }
        this.mCircleDrawable.setBounds(this.circleDrawableRect);
        super.onDraw(canvas);
    }

    private void regenerateBackground() {
        if (this.selectionDrawable != null) {
            this.setBackgroundDrawable(this.selectionDrawable);
        } else {
            this.mCircleDrawable = DayView.generateBackground(this.selectionColor, this.fadeTime, this.circleDrawableRect);
            this.setBackgroundDrawable(this.mCircleDrawable);
        }
    }

    private static Drawable generateBackground(int n, int n2, Rect rect) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.setExitFadeDuration(n2);
        stateListDrawable.addState(new int[]{0x10100A0}, DayView.generateCircleDrawable(n));
        if (Build.VERSION.SDK_INT >= 21) {
            stateListDrawable.addState(new int[]{16842919}, DayView.generateRippleDrawable(n, rect));
        } else {
            stateListDrawable.addState(new int[]{16842919}, DayView.generateCircleDrawable(n));
        }
        stateListDrawable.addState(new int[0], DayView.generateCircleDrawable(0));
        return stateListDrawable;
    }

    private static Drawable generateCircleDrawable(int n) {
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new OvalShape());
        shapeDrawable.getPaint().setColor(n);
        return shapeDrawable;
    }

    private static Drawable generateRippleDrawable(int n, Rect rect) {
        ColorStateList colorStateList = ColorStateList.valueOf((int)n);
        Drawable drawable2 = DayView.generateCircleDrawable(-1);
        RippleDrawable rippleDrawable = new RippleDrawable(colorStateList, null, drawable2);
        if (Build.VERSION.SDK_INT == 21) {
            rippleDrawable.setBounds(rect);
        }
        if (Build.VERSION.SDK_INT == 22) {
            int n2 = (rect.left + rect.right) / 2;
            rippleDrawable.setHotspotBounds(n2, rect.top, n2, rect.bottom);
        }
        return rippleDrawable;
    }

    void applyFacade(DayViewFacade dayViewFacade) {
        this.isDecoratedDisabled = dayViewFacade.areDaysDisabled();
        this.setEnabled();
        this.setCustomBackground(dayViewFacade.getBackgroundDrawable());
        this.setSelectionDrawable(dayViewFacade.getSelectionDrawable());
        List list = dayViewFacade.getSpans();
        if (!list.isEmpty()) {
            String string = this.getLabel();
            SpannableString spannableString = new SpannableString((CharSequence)this.getLabel());
            for (DayViewFacade$Span dayViewFacade$Span : list) {
                spannableString.setSpan(dayViewFacade$Span.span, 0, string.length(), 33);
            }
            this.setText((CharSequence)spannableString);
        } else {
            this.setText(this.getLabel());
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.calculateBounds(n3 - n, n4 - n2);
        this.regenerateBackground();
    }

    private void calculateBounds(int n, int n2) {
        int n3;
        int n4 = Math.min(n2, n);
        int n5 = Math.abs(n2 - n) / 2;
        int n6 = n3 = Build.VERSION.SDK_INT == 21 ? n5 / 2 : n5;
        if (n >= n2) {
            this.tempRect.set(n5, 0, n4 + n5, n2);
            this.circleDrawableRect.set(n3, 0, n4 + n3, n2);
        } else {
            this.tempRect.set(0, n5, n, n4 + n5);
            this.circleDrawableRect.set(0, n3, n, n4 + n3);
        }
    }
}

