/*
 * Decompiled with CFR 0.152.
 */
package oz.materialcalendarview;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ViewPropertyAnimator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.TextView;
import oz.materialcalendarview.CalendarDay;
import oz.materialcalendarview.TitleChanger$1;
import oz.materialcalendarview.format.TitleFormatter;

class TitleChanger {
    public static final int DEFAULT_ANIMATION_DELAY = 400;
    public static final int DEFAULT_Y_TRANSLATION_DP = 20;
    private final TextView title;
    private TitleFormatter titleFormatter = TitleFormatter.DEFAULT;
    private final int animDelay;
    private final int animDuration;
    private final int translate;
    private final Interpolator interpolator = new DecelerateInterpolator(2.0f);
    private int orientation = 0;
    private long lastAnimTime = 0L;
    private CalendarDay previousMonth = null;

    public TitleChanger(TextView textView) {
        this.title = textView;
        Resources resources = textView.getResources();
        this.animDelay = 400;
        this.animDuration = resources.getInteger(0x10E0000) / 2;
        this.translate = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public void change(CalendarDay calendarDay) {
        long l = System.currentTimeMillis();
        if (calendarDay == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.title.getText()) || l - this.lastAnimTime < (long)this.animDelay) {
            this.doChange(l, calendarDay, false);
        }
        if (calendarDay.equals(this.previousMonth) || calendarDay.getMonth() == this.previousMonth.getMonth() && calendarDay.getYear() == this.previousMonth.getYear()) {
            return;
        }
        this.doChange(l, calendarDay, true);
    }

    private void doChange(long l, CalendarDay calendarDay, boolean bl) {
        this.title.animate().cancel();
        this.doTranslation(this.title, 0);
        this.title.setAlpha(1.0f);
        this.lastAnimTime = l;
        CharSequence charSequence = this.titleFormatter.format(calendarDay);
        if (!bl) {
            this.title.setText(charSequence);
        } else {
            int n = this.translate * (this.previousMonth.isBefore(calendarDay) ? 1 : -1);
            ViewPropertyAnimator viewPropertyAnimator = this.title.animate();
            if (this.orientation == 1) {
                viewPropertyAnimator.translationX((float)(n * -1));
            } else {
                viewPropertyAnimator.translationY((float)(n * -1));
            }
            viewPropertyAnimator.alpha(0.0f).setDuration((long)this.animDuration).setInterpolator((TimeInterpolator)this.interpolator).setListener((Animator.AnimatorListener)new TitleChanger$1(this, charSequence, n)).start();
        }
        this.previousMonth = calendarDay;
    }

    private void doTranslation(TextView textView, int n) {
        if (this.orientation == 1) {
            textView.setTranslationX((float)n);
        } else {
            textView.setTranslationY((float)n);
        }
    }

    public void setTitleFormatter(TitleFormatter titleFormatter) {
        this.titleFormatter = titleFormatter == null ? TitleFormatter.DEFAULT : titleFormatter;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setPreviousMonth(CalendarDay calendarDay) {
        this.previousMonth = calendarDay;
    }

    static /* synthetic */ TextView access$000(TitleChanger titleChanger) {
        return titleChanger.title;
    }

    static /* synthetic */ void access$100(TitleChanger titleChanger, TextView textView, int n) {
        titleChanger.doTranslation(textView, n);
    }

    static /* synthetic */ int access$200(TitleChanger titleChanger) {
        return titleChanger.orientation;
    }

    static /* synthetic */ Interpolator access$300(TitleChanger titleChanger) {
        return titleChanger.interpolator;
    }

    static /* synthetic */ int access$400(TitleChanger titleChanger) {
        return titleChanger.animDuration;
    }
}

