/*
 * Decompiled with CFR 0.152.
 */
package oz.materialcalendarview;

import android.content.Context;
import android.os.Build;
import android.widget.TextView;
import org.threeten.bp.DayOfWeek;
import oz.materialcalendarview.format.WeekDayFormatter;

class WeekDayView
extends TextView {
    private WeekDayFormatter formatter = WeekDayFormatter.DEFAULT;
    private DayOfWeek dayOfWeek;

    public WeekDayView(Context context, DayOfWeek dayOfWeek) {
        super(context);
        this.setGravity(17);
        if (Build.VERSION.SDK_INT >= 17) {
            this.setTextAlignment(4);
        }
        this.setDayOfWeek(dayOfWeek);
    }

    public void setWeekDayFormatter(WeekDayFormatter weekDayFormatter) {
        this.formatter = weekDayFormatter == null ? WeekDayFormatter.DEFAULT : weekDayFormatter;
        this.setDayOfWeek(this.dayOfWeek);
    }

    public void setDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        this.setText(dayOfWeek);
    }

    public void setText(DayOfWeek dayOfWeek) {
        this.setText(this.formatter.format(dayOfWeek));
        if (dayOfWeek == DayOfWeek.SUNDAY) {
            this.setTextColor(-41364);
        } else if (dayOfWeek == DayOfWeek.SATURDAY) {
            this.setTextColor(-15891969);
        } else {
            this.setTextColor(-1);
        }
    }
}

