/*
 * Decompiled with CFR 0.152.
 */
package oz.util;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class OZDirectByteBufferInputStream
extends InputStream {
    ByteBuffer m_byteBuffer;
    int m_position;
    int m_size;
    int m_oriPosition;
    int m_oriSize;

    public OZDirectByteBufferInputStream(ByteBuffer byteBuffer, int n, int n2) {
        this.m_byteBuffer = byteBuffer;
        this.m_position = n;
        this.m_size = Math.min(n2, this.m_byteBuffer.capacity() - this.m_position);
        this.m_oriPosition = this.m_position;
        this.m_oriSize = this.m_size;
    }

    public int available() {
        return this.m_size - this.m_position;
    }

    public int read() {
        this.m_byteBuffer.position(this.m_position);
        byte by = this.m_byteBuffer.get();
        ++this.m_position;
        return by;
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = Math.min(n2, this.available());
        if (n3 > 0) {
            this.m_byteBuffer.position(this.m_position);
            this.m_byteBuffer.get(byArray, n, n3);
            this.m_position += n3;
            return n3;
        }
        return -1;
    }

    public long skip(long l) {
        long l2 = Math.min(l, (long)this.available());
        this.m_position = (int)((long)this.m_position + l2);
        return l2;
    }

    public synchronized void reset() {
        this.m_position = this.m_oriPosition;
        this.m_size = this.m_oriSize;
    }
}

