/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Reader;
import oz.util.barcode.ReaderException;
import oz.util.barcode.Result;
import oz.util.barcode.aztec.AztecReader;
import oz.util.barcode.datamatrix.DataMatrixReader;
import oz.util.barcode.maxicode.MaxiCodeReader;
import oz.util.barcode.oned.MultiFormatOneDReader;
import oz.util.barcode.pdf417.PDF417Reader;
import oz.util.barcode.qrcode.QRCodeReader;

public final class MultiFormatReader
implements Reader {
    private Map hints;
    private Reader[] readers;

    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        this.setHints(null);
        return this.decodeInternal(binaryBitmap);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map map) {
        this.setHints(map);
        return this.decodeInternal(binaryBitmap);
    }

    public Result decodeWithState(BinaryBitmap binaryBitmap) {
        if (this.readers == null) {
            this.setHints(null);
        }
        return this.decodeInternal(binaryBitmap);
    }

    public void setHints(Map map) {
        this.hints = map;
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        Collection collection = map == null ? null : (Collection)map.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<Reader> arrayList = new ArrayList<Reader>();
        if (collection != null) {
            boolean bl2;
            boolean bl3 = bl2 = collection.contains((Object)BarcodeFormat.UPC_A) || collection.contains((Object)BarcodeFormat.UPC_E) || collection.contains((Object)BarcodeFormat.EAN_13) || collection.contains((Object)BarcodeFormat.EAN_8) || collection.contains((Object)BarcodeFormat.CODABAR) || collection.contains((Object)BarcodeFormat.CODE_39) || collection.contains((Object)BarcodeFormat.CODE_93) || collection.contains((Object)BarcodeFormat.CODE_128) || collection.contains((Object)BarcodeFormat.ITF) || collection.contains((Object)BarcodeFormat.RSS_14) || collection.contains((Object)BarcodeFormat.RSS_EXPANDED);
            if (bl2 && !bl) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
            if (collection.contains((Object)BarcodeFormat.QR_CODE)) {
                arrayList.add(new QRCodeReader());
            }
            if (collection.contains((Object)BarcodeFormat.DATA_MATRIX)) {
                arrayList.add(new DataMatrixReader());
            }
            if (collection.contains((Object)BarcodeFormat.AZTEC)) {
                arrayList.add(new AztecReader());
            }
            if (collection.contains((Object)BarcodeFormat.PDF_417)) {
                arrayList.add(new PDF417Reader());
            }
            if (collection.contains((Object)BarcodeFormat.MAXICODE)) {
                arrayList.add(new MaxiCodeReader());
            }
            if (bl2 && bl) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
        }
        if (arrayList.isEmpty()) {
            if (!bl) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
            arrayList.add(new QRCodeReader());
            arrayList.add(new DataMatrixReader());
            arrayList.add(new AztecReader());
            arrayList.add(new PDF417Reader());
            arrayList.add(new MaxiCodeReader());
            if (bl) {
                arrayList.add(new MultiFormatOneDReader(map));
            }
        }
        this.readers = arrayList.toArray(new Reader[arrayList.size()]);
    }

    @Override
    public void reset() {
        if (this.readers != null) {
            Reader[] readerArray = this.readers;
            int n = this.readers.length;
            int n2 = 0;
            while (n2 < n) {
                Reader reader = readerArray[n2];
                reader.reset();
                ++n2;
            }
        }
    }

    private Result decodeInternal(BinaryBitmap binaryBitmap) {
        if (this.readers != null) {
            Reader[] readerArray = this.readers;
            int n = this.readers.length;
            int n2 = 0;
            while (n2 < n) {
                Reader reader = readerArray[n2];
                try {
                    return reader.decode(binaryBitmap, this.hints);
                }
                catch (ReaderException readerException) {
                    ++n2;
                }
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

