/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import oz.util.barcode.client.android.camera.CameraManager;

final class AmbientLightManager
implements SensorEventListener {
    private static final float TOO_DARK_LUX = 45.0f;
    private static final float BRIGHT_ENOUGH_LUX = 450.0f;
    private final Context context;
    private CameraManager cameraManager;
    private Sensor lightSensor;
    private String flashMode = "Auto";

    AmbientLightManager(Context context) {
        this.context = context;
    }

    public void setFlashMode(String string) {
        this.flashMode = string;
    }

    void start(CameraManager cameraManager) {
        this.cameraManager = cameraManager;
        SensorManager sensorManager = (SensorManager)this.context.getSystemService("sensor");
        this.lightSensor = sensorManager.getDefaultSensor(5);
        if (this.lightSensor != null) {
            sensorManager.registerListener((SensorEventListener)this, this.lightSensor, 3);
        }
    }

    void stop() {
        if (this.lightSensor != null) {
            SensorManager sensorManager = (SensorManager)this.context.getSystemService("sensor");
            sensorManager.unregisterListener((SensorEventListener)this);
            this.cameraManager = null;
            this.lightSensor = null;
        }
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (this.flashMode.equals("Auto")) {
            float f2 = sensorEvent.values[0];
            if (this.cameraManager != null) {
                if (f2 <= 45.0f) {
                    this.cameraManager.setTorch(true);
                } else if (f2 >= 450.0f) {
                    this.cameraManager.setTorch(false);
                }
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }
}

