/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import oz.util.barcode.client.android.InactivityTimer$InactivityAsyncTask;
import oz.util.barcode.client.android.InactivityTimer$PowerStatusReceiver;
import oz.util.barcode.client.android.common.executor.AsyncTaskExecInterface;
import oz.util.barcode.client.android.common.executor.AsyncTaskExecManager;

final class InactivityTimer {
    private static final String TAG = InactivityTimer.class.getSimpleName();
    private static final long INACTIVITY_DELAY_MS = 300000L;
    private final Activity activity;
    private final AsyncTaskExecInterface taskExec;
    private final BroadcastReceiver powerStatusReceiver;
    private InactivityTimer$InactivityAsyncTask inactivityTask;

    InactivityTimer(Activity activity) {
        this.activity = activity;
        this.taskExec = (AsyncTaskExecInterface)new AsyncTaskExecManager().build();
        this.powerStatusReceiver = new InactivityTimer$PowerStatusReceiver(this, null);
        this.onActivity();
    }

    synchronized void onActivity() {
        this.cancel();
        this.inactivityTask = new InactivityTimer$InactivityAsyncTask(this, null);
        this.taskExec.execute(this.inactivityTask, new Object[0]);
    }

    public void onPause() {
        this.cancel();
        this.activity.unregisterReceiver(this.powerStatusReceiver);
    }

    public void onResume() {
        this.activity.registerReceiver(this.powerStatusReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        this.onActivity();
    }

    private synchronized void cancel() {
        InactivityTimer$InactivityAsyncTask inactivityTimer$InactivityAsyncTask = this.inactivityTask;
        if (inactivityTimer$InactivityAsyncTask != null) {
            inactivityTimer$InactivityAsyncTask.cancel(true);
            this.inactivityTask = null;
        }
    }

    void shutdown() {
        this.cancel();
    }

    static /* synthetic */ void access$200(InactivityTimer inactivityTimer) {
        inactivityTimer.cancel();
    }

    static /* synthetic */ String access$300() {
        return TAG;
    }

    static /* synthetic */ Activity access$400(InactivityTimer inactivityTimer) {
        return inactivityTimer.activity;
    }
}

