/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import oz.client.shape.ui.ICEditWnd;
import oz.main.MainFrameView;
import oz.main.OZStorage;
import oz.resource.OZAndroidResource;
import oz.util.OZButton;
import oz.util.barcode.Result;
import oz.util.barcode.client.android.AmbientLightManager;
import oz.util.barcode.client.android.BeepManager;
import oz.util.barcode.client.android.FinishListener;
import oz.util.barcode.client.android.InactivityTimer;
import oz.util.barcode.client.android.OZCaptureHandler;
import oz.util.barcode.client.android.OZCaptureView$1;
import oz.util.barcode.client.android.OZCaptureView$2;
import oz.util.barcode.client.android.OZCaptureView$3;
import oz.util.barcode.client.android.OZCaptureView$4;
import oz.util.barcode.client.android.OZCaptureView$5;
import oz.util.barcode.client.android.OZCaptureView$CaptureViewHandler;
import oz.util.barcode.client.android.ViewfinderView;
import oz.util.barcode.client.android.camera.CameraManager;

public final class OZCaptureView
extends FrameLayout
implements SurfaceHolder.Callback,
View.OnClickListener {
    private static final String TAG = "OZViewerBarcode";
    public static final int decode = 2131230720;
    public static final int decode_failed = 2131230721;
    public static final int decode_succeeded = 2131230722;
    public static final int launch_product_query = 2131230723;
    public static final int quit = 2131230724;
    public static final int restart_preview = 2131230725;
    public static final int return_scan_result = 2131230726;
    private OZCaptureView$CaptureViewHandler mCaptureViewHandler = new OZCaptureView$CaptureViewHandler(this, null);
    private CameraManager cameraManager;
    private OZCaptureHandler handler;
    private Result savedResultToShow;
    private ViewfinderView viewfinderView;
    private LinearLayout resultView;
    private Collection decodeFormats;
    private Map decodeHints;
    private String characterSet;
    private InactivityTimer inactivityTimer;
    private BeepManager beepManager;
    private AmbientLightManager ambientLightManager;
    private EditText resultEdit;
    private TextView statusView;
    private Button flash;
    private String flashMode = "Auto";
    private boolean mIgnoreDecode = false;
    boolean isShowKeyboard = false;
    Dialog m_dialog;
    SurfaceView m_surfaceView;
    SurfaceHolder mHolder;
    String[] m_resultBarcode;
    ICEditWnd m_editText;
    TextView barcodeFormat_tv;
    private boolean isFirst = true;
    private int m_width;
    private int m_height;
    String result_value = "";
    private long last_refocus = 0L;

    public EditText getResultEdit() {
        return this.resultEdit;
    }

    public String getBarcodeResult() {
        if (this.resultEdit != null) {
            return this.resultEdit.getText().toString();
        }
        return "";
    }

    ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public Handler getHandler() {
        return this.handler;
    }

    CameraManager getCameraManager() {
        return this.cameraManager;
    }

    public Point getPreviewSize(Camera.Parameters parameters, Point point) {
        return new CameraManager(this.getContext()).getPreviewSize(parameters, point);
    }

    private void showKeyboard() {
        this.resultEdit.setCursorVisible(true);
        this.changeView();
        this.isShowKeyboard = true;
    }

    private void hideKeyboard() {
        this.resultEdit.setCursorVisible(false);
        this.resetStatusView();
        this.isShowKeyboard = false;
    }

    public void setText(String string) {
        this.resultEdit.setText((CharSequence)string);
    }

    private void downKeyboard() {
        if (this.isShowKeyboard) {
            InputMethodManager inputMethodManager = (InputMethodManager)this.resultEdit.getContext().getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(this.resultEdit.getWindowToken(), 0);
        } else {
            this.hideKeyboard();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        switch (n & 0xFF) {
            case 0: {
                long l = System.currentTimeMillis();
                if (l - this.last_refocus <= 1000L) break;
                this.last_refocus = l;
                this.cameraManager.reFocus();
            }
        }
        return super.onTouchEvent(motionEvent);
    }

    public void setDecodeHints(Map map) {
        this.decodeHints = map;
    }

    public void setDecodeFormats(Collection collection) {
        this.decodeFormats = collection;
    }

    public void startPreview() {
        if (!this.cameraManager.isPreviewing()) {
            this.cameraManager.startPreview();
        }
    }

    public void stopPreview() {
        this.cameraManager.stopPreview();
    }

    public LinearLayout resultView() {
        Object object;
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        this.statusView = new TextView(this.getContext());
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setGravity(17);
        linearLayout2.setWeightSum(1.0f);
        TextView textView = new TextView(this.getContext());
        textView.setTextColor(-1);
        textView.setText((CharSequence)"\uacb0\uacfc : ");
        textView.setTypeface(null, 1);
        ScrollView scrollView = new ScrollView(this.getContext());
        scrollView.setFillViewport(true);
        this.resultEdit = new EditText(this.getContext());
        this.resultEdit.setCursorVisible(false);
        this.resultEdit.setBackgroundColor(0x4D000000);
        this.resultEdit.setEnabled(false);
        this.resultEdit.setTextColor(-1);
        this.resultEdit.setTextSize(this.getButtonTextSize());
        this.resultEdit.setPadding(OZStorage.DpToPx(this.getContext(), 5.0f, true), 0, OZStorage.DpToPx(this.getContext(), 5.0f, true), 0);
        if (!this.m_editText.m_isMultiLine) {
            this.resultEdit.setSingleLine();
            this.resultEdit.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        } else {
            this.resultEdit.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        }
        scrollView.addView((View)this.resultEdit);
        if (this.m_editText.m_text.equals("")) {
            this.resultEdit.setGravity(17);
            this.resultEdit.setText((CharSequence)OZAndroidResource.getResource("barcode.scanning.msg"));
        } else {
            this.resultEdit.setGravity(19);
        }
        Button button = new Button(this.getContext());
        try {
            object = "barcode/confirm@1.5.png";
            Drawable drawable2 = this.getDrawable(this.getResources().getAssets().open(this.getImagePath((String)object)));
            button.setBackgroundDrawable(drawable2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        button.setTextColor(-16777216);
        button.setText((CharSequence)"\ud655\uc778");
        button.setOnClickListener((View.OnClickListener)new OZCaptureView$1(this));
        object = this.m_editText.getBarcodeKeyboardButton();
        object.setOnClickListener((View.OnClickListener)new OZCaptureView$2(this));
        int n = OZStorage.DpToPx(this.getContext(), 1.0f, false);
        LinearLayout linearLayout3 = new LinearLayout(this.getContext());
        linearLayout3.setOrientation(1);
        LinearLayout linearLayout4 = new LinearLayout(this.getContext());
        linearLayout4.setBackgroundColor(-8355712);
        linearLayout3.addView((View)linearLayout4, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, OZStorage.DpToPx(this.getContext(), 1.0f, true)));
        LinearLayout linearLayout5 = new LinearLayout(this.getContext());
        LinearLayout linearLayout6 = new LinearLayout(this.getContext());
        linearLayout6.setBackgroundColor(-8355712);
        LinearLayout linearLayout7 = new LinearLayout(this.getContext());
        linearLayout7.setBackgroundColor(-8355712);
        linearLayout5.addView((View)linearLayout6, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(OZStorage.DpToPx(this.getContext(), 1.0f, true), -1));
        linearLayout5.addView((View)scrollView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        linearLayout5.addView((View)linearLayout7, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(OZStorage.DpToPx(this.getContext(), 1.0f, true), -1));
        linearLayout3.addView((View)linearLayout5, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        LinearLayout linearLayout8 = new LinearLayout(this.getContext());
        linearLayout8.setBackgroundColor(-8355712);
        linearLayout3.addView((View)linearLayout8, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, OZStorage.DpToPx(this.getContext(), 1.0f, true)));
        LinearLayout linearLayout9 = new LinearLayout(this.getContext());
        linearLayout9.addView((View)object);
        linearLayout9.setGravity(16);
        linearLayout2.setPadding(OZStorage.DpToPx(this.getContext(), 10.0f, true), 0, OZStorage.DpToPx(this.getContext(), 10.0f, true), OZStorage.DpToPx(this.getContext(), 10.0f, false));
        linearLayout2.addView((View)linearLayout3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1, 1.0f));
        linearLayout2.addView(new View(this.getContext()), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(OZStorage.DpToPx(this.getContext(), 5.0f, true), -1));
        linearLayout2.addView((View)linearLayout9, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        return linearLayout;
    }

    public OZCaptureView(Context context, Dialog dialog, String[] stringArray, ICEditWnd iCEditWnd) {
        super(context);
        this.m_dialog = dialog;
        this.m_resultBarcode = stringArray;
        this.m_editText = iCEditWnd;
        this.inactivityTimer = new InactivityTimer((Activity)context);
        this.beepManager = new BeepManager((Activity)context);
        this.ambientLightManager = new AmbientLightManager(context);
        this.m_surfaceView = new SurfaceView(context);
        this.m_surfaceView.bringToFront();
        this.viewfinderView = new ViewfinderView(context, null);
        this.addView((View)this.m_surfaceView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView(this.viewfinderView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.resultView = this.resultView();
        this.addView((View)this.resultView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, 81));
        this.mHolder = this.m_surfaceView.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.mHolder.setType(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void LoadAndSaveToProps(boolean bl) {
        Properties properties = new Properties();
        File file = new File(this.getContext().getCacheDir(), "oz_camera.properties");
        if (file.exists() && !bl) {
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            this.flashMode = properties.getProperty("FlashMode");
            Object var7_6 = null;
            if (fileInputStream == null) return;
            try {
                fileInputStream.close();
                return;
            }
            catch (Exception exception) {}
            return;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var7_7 = null;
                    if (fileInputStream == null) return;
                    try {
                        fileInputStream.close();
                        return;
                    }
                    catch (Exception exception2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        FileOutputStream fileOutputStream = null;
        properties.setProperty("FlashMode", this.flashMode);
        fileOutputStream = new FileOutputStream(file);
        properties.save(fileOutputStream, "Camera Flash mode");
        Object var10_15 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var10_16 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (Exception exception3) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setEditTextEnable(boolean bl) {
        this.resultEdit.setEnabled(bl);
    }

    public void setEditTextColor(int n) {
        this.resultEdit.setTextColor(n);
    }

    protected void init() {
        this.cameraManager = new CameraManager(this.getContext());
        this.viewfinderView.setCameraManager(this.cameraManager);
        this.handler = null;
        this.resetStatusView();
        this.initCamera();
        this.beepManager.updatePrefs();
        this.inactivityTimer.onResume();
        this.barcodeFormat();
    }

    private void flashBtn() {
        if (this.cameraManager == null || !this.cameraManager.isCameraFlash()) {
            return;
        }
        if (!this.isFirst) {
            return;
        }
        this.flash = new Button(this.getContext());
        this.flash.setBackgroundColor(-1610612736);
        this.flash.setTextColor(-1);
        this.LoadAndSaveToProps(false);
        if (this.flashMode.equals("ON")) {
            this.cameraManager.setTorch(true);
        } else if (this.flashMode.equals("OFF")) {
            this.cameraManager.setTorch(false);
        }
        this.ambientLightManager.setFlashMode(this.flashMode);
        this.flash.setText((CharSequence)("FLASH : " + this.flashMode));
        this.flash.setOnClickListener((View.OnClickListener)new OZCaptureView$3(this));
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        TextView textView = new TextView(this.getContext());
        textView.setHeight(15);
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setOrientation(0);
        TextView textView2 = new TextView(this.getContext());
        textView2.setWidth(15);
        linearLayout2.addView((View)this.flash);
        linearLayout2.addView((View)textView2);
        linearLayout.addView((View)textView);
        linearLayout.addView((View)linearLayout2);
        this.addView((View)linearLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 53));
    }

    private void barcodeFormat() {
        this.barcodeFormat_tv = new TextView(this.getContext());
        this.barcodeFormat_tv.setTextColor(-65536);
        this.barcodeFormat_tv.setTextSize(this.getButtonTextSize());
        this.barcodeFormat_tv.setGravity(49);
        this.addView((View)this.barcodeFormat_tv, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 49));
    }

    protected void release() {
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        this.inactivityTimer.onPause();
        this.ambientLightManager.stop();
        this.cameraManager.closeDriver();
        this.mHolder.removeCallback((SurfaceHolder.Callback)this);
        this.inactivityTimer.shutdown();
        this.resultView.setVisibility(4);
        try {
            if (this.m_dialog != null) {
                this.m_dialog.dismiss();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void decodeOrStoreSavedBitmap(Bitmap bitmap, Result result) {
        if (this.handler == null) {
            this.savedResultToShow = result;
        } else {
            if (result != null) {
                this.savedResultToShow = result;
            }
            if (this.savedResultToShow != null) {
                Message message = Message.obtain((Handler)this.handler, (int)2131230722, (Object)this.savedResultToShow);
                this.handler.sendMessage(message);
            }
            this.savedResultToShow = null;
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            Log.e((String)TAG, (String)"*** WARNING *** surfaceCreated() gave us a null surface!");
        }
        this.isFirst = true;
        this.init();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.release();
        this.isFirst = true;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        Log.e((String)"surface", (String)("" + n2 + " " + n3));
        if (this.isFirst) {
            this.m_width = n2;
            this.m_height = n3;
            this.isFirst = false;
        } else {
            if (this.m_width == n2 && this.m_height > n3) {
                this.showKeyboard();
            } else {
                this.hideKeyboard();
            }
            if (this.m_width != n2) {
                this.cameraManager.closeDriver();
                this.post(new OZCaptureView$4(this));
            }
            this.m_width = n2;
            this.m_height = n3;
        }
    }

    private DisplayMetrics getDisplayMetrics(Context context) {
        if (context != null) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            return displayMetrics;
        }
        return null;
    }

    private String convertBarcodeFormatName(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("AZTEC")) {
                return "AZTEC";
            }
            if (string.equalsIgnoreCase("CODABAR")) {
                return "CODABAR";
            }
            if (string.equalsIgnoreCase("CODE_39")) {
                return "CODE39";
            }
            if (string.equalsIgnoreCase("CODE_93")) {
                return "CODE93_MOD47";
            }
            if (string.equalsIgnoreCase("CODE_128")) {
                return "CODE128AUTO_MOD103";
            }
            if (string.equalsIgnoreCase("DATA_MATRIX")) {
                return "DATAMATRIX";
            }
            if (string.equalsIgnoreCase("EAN_8")) {
                return "EAN8";
            }
            if (string.equalsIgnoreCase("EAN_13")) {
                return "EAN13";
            }
            if (string.equalsIgnoreCase("ITF")) {
                return "ITF";
            }
            if (string.equalsIgnoreCase("MAXICODE")) {
                return "MAXICODE";
            }
            if (string.equalsIgnoreCase("PDF_417")) {
                return "PDF417";
            }
            if (string.equalsIgnoreCase("QR_CODE")) {
                return "QRCODE";
            }
            if (string.equalsIgnoreCase("RSS_14")) {
                return "RSS14";
            }
            if (string.equalsIgnoreCase("RSS_EXPANDED")) {
                return "RSS_EXPANDED";
            }
            if (string.equalsIgnoreCase("UPC_A")) {
                return "UPCA";
            }
            if (string.equalsIgnoreCase("UPC_E")) {
                return "UPCE";
            }
            if (string.equalsIgnoreCase("UPC_EAN_EXTENSION")) {
                return "UPC_EAN_EXTENSION";
            }
        }
        return "";
    }

    public void handleDecode(Result result) {
        this.inactivityTimer.onActivity();
        if (!this.mIgnoreDecode) {
            this.mIgnoreDecode = true;
            if (result != null) {
                this.cameraManager.stopPreview();
                String string = result.getText();
                String string2 = result.getBarcodeFormat() != null ? result.getBarcodeFormat().name() : null;
                String string3 = this.convertBarcodeFormatName(string2);
                String string4 = this.m_editText.nativeBarcodeOnFilter(string, string3);
                if (string4 == null) {
                    Log.i((String)TAG, (String)"DecodeMessage is null");
                    this.mCaptureViewHandler.requestRestart();
                } else if (!string4.isEmpty()) {
                    Log.i((String)TAG, (String)String.format("DecodeMessage : %s", string4));
                    OZCaptureView$5 oZCaptureView$5 = new OZCaptureView$5(this);
                    MainFrameView.AlertDialog("", string4, oZCaptureView$5);
                } else {
                    this.beepManager.playBeepSoundAndVibrate();
                    Log.d((String)TAG, (String)("Barcode result===" + string + ", timestamp=" + result.getTimestamp() + " barcode name=" + string2));
                    String string5 = "";
                    string5 = string != null && !this.m_editText.m_isMultiLine ? string.replaceAll("[\n\r]", "") : string;
                    this.m_editText.nativeOnChange(string5);
                    this.result_value = this.m_editText.m_text;
                    this.resultEdit.setText((CharSequence)this.m_editText.m_text);
                    this.resultEdit.setGravity(19);
                    this.barcodeFormat_tv.setText((CharSequence)("Type : " + string3));
                    this.barcodeFormat_tv.setPadding(0, OZStorage.DpToPx(this.getContext(), 20.0f, false), 0, 0);
                    ((Button)ICEditWnd.mPopupDlg.findViewById(65534)).setText((CharSequence)OZAndroidResource.getResource("barcode.rescan"));
                }
            } else {
                this.result_value = "";
                this.resultEdit.setText((CharSequence)"");
            }
            this.changeView();
            this.mIgnoreDecode = false;
        } else {
            Log.i((String)TAG, (String)"ignore DecodeMessage");
        }
    }

    private float getButtonTextSize() {
        float f2 = new OZButton(this.getContext()).getTextSize();
        float f3 = 1.0f;
        float f4 = 1.0f;
        f3 = OZStorage.getDensityDPI();
        if (!(OZStorage.getDensityDPI() <= 1.0f)) {
            if (OZStorage.getDensityDPI() > 1.0f && OZStorage.getDensityDPI() < 2.0f) {
                f4 = OZStorage.getDensityDPI();
            } else if (OZStorage.getDensityDPI() > 1.0f && OZStorage.getDensityDPI() < 4.0f) {
                f4 = OZStorage.getDensityDPI() / 1.8f;
            } else {
                f4 = OZStorage.getDensityDPI() / 1.8f;
                f4 /= 1.2f;
            }
        }
        f2 = f2 * 1.5f / f3 / f4;
        return f2;
    }

    public String getResultValue() {
        return this.result_value;
    }

    private void initCamera() {
        if (this.mHolder == null) {
            throw new IllegalStateException("No SurfaceHolder provided");
        }
        if (this.cameraManager.isOpen()) {
            Log.w((String)TAG, (String)"initCamera() while already open -- late SurfaceView callback?");
            return;
        }
        try {
            try {
                this.cameraManager.openDriver(this.mHolder);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (this.handler == null) {
                this.handler = new OZCaptureHandler(this, this.decodeFormats, this.decodeHints, this.characterSet, this.cameraManager);
            }
            this.decodeOrStoreSavedBitmap(null, null);
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)TAG, (String)"Unexpected error initializing camera", (Throwable)runtimeException);
            this.displayFrameworkBugMessageAndExit(runtimeException.getLocalizedMessage());
        }
    }

    private void displayFrameworkBugMessageAndExit(String string) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle((CharSequence)TAG);
        builder.setMessage((CharSequence)string);
        builder.setPositiveButton((CharSequence)"OK", (DialogInterface.OnClickListener)new FinishListener((Activity)this.getContext()));
        builder.setOnCancelListener((DialogInterface.OnCancelListener)new FinishListener((Activity)this.getContext()));
        builder.show();
    }

    public void restartPreviewAfterDelay(long l) {
        if (this.handler != null) {
            this.handler.sendEmptyMessageDelayed(2131230725, l);
        }
        this.resetStatusView();
    }

    private void resetStatusView() {
        this.viewfinderView.setVisibility(0);
    }

    private void changeView() {
        this.viewfinderView.setVisibility(4);
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    private Drawable getDrawable(InputStream inputStream) {
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        bitmap.setDensity(0);
        return new BitmapDrawable(bitmap);
    }

    private String getImagePath(String string) {
        Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        if ((double)displayMetrics.scaledDensity <= 1.5) {
            string = string.replace("@1.5", "");
            string = string.replace("@2x", "");
            return string;
        }
        return string;
    }

    public void onClick(View view) {
        if (!this.cameraManager.isPreviewing()) {
            ((Button)ICEditWnd.mPopupDlg.findViewById(65534)).setText((CharSequence)OZAndroidResource.getResource("barcode.scan"));
            this.barcodeFormat_tv.setText((CharSequence)"");
            if (view != null) {
                this.m_editText.nativeOnChange("");
            }
            if (this.m_editText.m_text.isEmpty()) {
                this.resultEdit.setGravity(17);
                this.resultEdit.setText((CharSequence)OZAndroidResource.getResource("barcode.scanning.msg"));
            } else {
                this.resultEdit.setGravity(3);
                this.resultEdit.setText((CharSequence)this.m_editText.m_text);
            }
            this.cameraManager.startPreview();
            this.restartPreviewAfterDelay(1000L);
        } else {
            long l = System.currentTimeMillis();
            if (l - this.last_refocus > 1000L) {
                this.last_refocus = l;
                this.cameraManager.reFocus();
            }
        }
    }

    static /* synthetic */ EditText access$000(OZCaptureView oZCaptureView) {
        return oZCaptureView.resultEdit;
    }

    static /* synthetic */ CameraManager access$200(OZCaptureView oZCaptureView) {
        return oZCaptureView.cameraManager;
    }

    static /* synthetic */ String access$300(OZCaptureView oZCaptureView) {
        return oZCaptureView.flashMode;
    }

    static /* synthetic */ String access$302(OZCaptureView oZCaptureView, String string) {
        oZCaptureView.flashMode = string;
        return oZCaptureView.flashMode;
    }

    static /* synthetic */ void access$400(OZCaptureView oZCaptureView, boolean bl) {
        oZCaptureView.LoadAndSaveToProps(bl);
    }

    static /* synthetic */ Button access$500(OZCaptureView oZCaptureView) {
        return oZCaptureView.flash;
    }

    static /* synthetic */ AmbientLightManager access$600(OZCaptureView oZCaptureView) {
        return oZCaptureView.ambientLightManager;
    }

    static /* synthetic */ OZCaptureView$CaptureViewHandler access$700(OZCaptureView oZCaptureView) {
        return oZCaptureView.mCaptureViewHandler;
    }
}

