/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import oz.main.OZStorage;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.client.android.camera.CameraManager;

public final class ViewfinderView
extends View {
    private static final int[] SCANNER_ALPHA = new int[]{0, 64, 128, 192, 255, 192, 128, 64};
    private static final long ANIMATION_DELAY = 80L;
    private static final int CURRENT_POINT_OPACITY = 160;
    private static final int MAX_RESULT_POINTS = 20;
    private static final int POINT_SIZE = 6;
    private CameraManager cameraManager;
    private final Paint paint = new Paint(1);
    private Bitmap resultBitmap;
    private final int maskColor;
    private final int resultColor;
    private final int laserColor;
    private final int resultPointColor;
    private int scannerAlpha;
    private List possibleResultPoints;
    private List lastPossibleResultPoints;

    public ViewfinderView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Resources resources = this.getResources();
        this.maskColor = 0x60000000;
        this.resultColor = -1342177280;
        this.laserColor = -3407872;
        this.resultPointColor = -1056981727;
        this.scannerAlpha = 0;
        this.possibleResultPoints = new ArrayList(5);
        this.lastPossibleResultPoints = null;
    }

    public void setCameraManager(CameraManager cameraManager) {
        this.cameraManager = cameraManager;
    }

    public void onDraw(Canvas canvas) {
        if (this.cameraManager == null) {
            return;
        }
        if (this.getParent() == null) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)this.getParent();
        Rect rect = this.cameraManager.getFramingRect();
        int n = viewGroup.getHeight();
        int n2 = viewGroup.getWidth();
        if (rect == null) {
            return;
        }
        this.paint.setColor(this.resultBitmap != null ? this.resultColor : this.maskColor);
        if (this.resultBitmap != null) {
            this.paint.setAlpha(160);
            canvas.drawBitmap(this.resultBitmap, null, rect, this.paint);
        } else {
            this.paint.setColor(this.laserColor);
            canvas.drawRect((float)canvas.getWidth() * 0.1f, (float)(n / 2), (float)n2 - (float)canvas.getWidth() * 0.1f, (float)(n / 2 + OZStorage.DpToPx(this.getContext(), 1.0f, false)), this.paint);
            this.postInvalidateDelayed(80L, rect.left - 6, rect.top - 6, rect.right + 6, rect.bottom + 6);
        }
    }

    public void drawViewfinder() {
        Bitmap bitmap = this.resultBitmap;
        this.resultBitmap = null;
        if (bitmap != null) {
            bitmap.recycle();
        }
        this.invalidate();
    }

    public void drawResultBitmap(Bitmap bitmap) {
        this.resultBitmap = bitmap;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPossibleResultPoint(ResultPoint resultPoint) {
        List list;
        List list2 = list = this.possibleResultPoints;
        synchronized (list2) {
            list.add(resultPoint);
            int n = list.size();
            if (n > 20) {
                list.subList(0, n - 10).clear();
            }
        }
    }
}

