/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.common.detector;

import oz.util.barcode.NotFoundException;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.detector.MathUtils;

public final class WhiteRectangleDetector {
    private static final int INIT_SIZE = 10;
    private static final int CORR = 1;
    private final BitMatrix image;
    private final int height;
    private final int width;
    private final int leftInit;
    private final int rightInit;
    private final int downInit;
    private final int upInit;

    public WhiteRectangleDetector(BitMatrix bitMatrix) {
        this(bitMatrix, 10, bitMatrix.getWidth() / 2, bitMatrix.getHeight() / 2);
    }

    public WhiteRectangleDetector(BitMatrix bitMatrix, int n, int n2, int n3) {
        this.image = bitMatrix;
        this.height = bitMatrix.getHeight();
        this.width = bitMatrix.getWidth();
        int n4 = n / 2;
        this.leftInit = n2 - n4;
        this.rightInit = n2 + n4;
        this.upInit = n3 - n4;
        this.downInit = n3 + n4;
        if (this.upInit < 0 || this.leftInit < 0 || this.downInit >= this.height || this.rightInit >= this.width) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    public ResultPoint[] detect() {
        int n;
        int n2;
        int n3;
        int n4 = this.leftInit;
        int n5 = this.rightInit;
        int n6 = this.upInit;
        int n7 = this.downInit;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        while (bl2) {
            bl2 = false;
            n3 = 1;
            while (n3 != 0 && n5 < this.width) {
                n3 = this.containsBlackPoint(n6, n7, n5, false) ? 1 : 0;
                if (n3 == 0) continue;
                ++n5;
                bl2 = true;
            }
            if (n5 >= this.width) {
                bl = true;
                break;
            }
            boolean bl4 = true;
            while (bl4 && n7 < this.height) {
                bl4 = this.containsBlackPoint(n4, n5, n7, true);
                if (!bl4) continue;
                ++n7;
                bl2 = true;
            }
            if (n7 >= this.height) {
                bl = true;
                break;
            }
            n2 = 1;
            while (n2 != 0 && n4 >= 0) {
                n2 = this.containsBlackPoint(n6, n7, n4, false) ? 1 : 0;
                if (n2 == 0) continue;
                --n4;
                bl2 = true;
            }
            if (n4 < 0) {
                bl = true;
                break;
            }
            n = 1;
            while (n != 0 && n6 >= 0) {
                n = this.containsBlackPoint(n4, n5, n6, true) ? 1 : 0;
                if (n == 0) continue;
                --n6;
                bl2 = true;
            }
            if (n6 < 0) {
                bl = true;
                break;
            }
            if (!bl2) continue;
            bl3 = true;
        }
        if (!bl && bl3) {
            n3 = n5 - n4;
            ResultPoint resultPoint = null;
            n2 = 1;
            while (n2 < n3) {
                resultPoint = this.getBlackPointOnSegment(n4, n7 - n2, n4 + n2, n7);
                if (resultPoint != null) break;
                ++n2;
            }
            if (resultPoint == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint2 = null;
            n = 1;
            while (n < n3) {
                resultPoint2 = this.getBlackPointOnSegment(n4, n6 + n, n4 + n, n6);
                if (resultPoint2 != null) break;
                ++n;
            }
            if (resultPoint2 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint3 = null;
            int n8 = 1;
            while (n8 < n3) {
                resultPoint3 = this.getBlackPointOnSegment(n5, n6 + n8, n5 - n8, n6);
                if (resultPoint3 != null) break;
                ++n8;
            }
            if (resultPoint3 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint4 = null;
            int n9 = 1;
            while (n9 < n3) {
                resultPoint4 = this.getBlackPointOnSegment(n5, n7 - n9, n5 - n9, n7);
                if (resultPoint4 != null) break;
                ++n9;
            }
            if (resultPoint4 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            return this.centerEdges(resultPoint4, resultPoint, resultPoint3, resultPoint2);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private ResultPoint getBlackPointOnSegment(float f2, float f3, float f4, float f5) {
        int n = MathUtils.round(MathUtils.distance(f2, f3, f4, f5));
        float f6 = (f4 - f2) / (float)n;
        float f7 = (f5 - f3) / (float)n;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = MathUtils.round(f2 + (float)n2 * f6);
            if (this.image.get(n4, n3 = MathUtils.round(f3 + (float)n2 * f7))) {
                return new ResultPoint(n4, n3);
            }
            ++n2;
        }
        return null;
    }

    private ResultPoint[] centerEdges(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) {
        float f2 = resultPoint.getX();
        float f3 = resultPoint.getY();
        float f4 = resultPoint2.getX();
        float f5 = resultPoint2.getY();
        float f6 = resultPoint3.getX();
        float f7 = resultPoint3.getY();
        float f8 = resultPoint4.getX();
        float f9 = resultPoint4.getY();
        if (f2 < (float)this.width / 2.0f) {
            return new ResultPoint[]{new ResultPoint(f8 - 1.0f, f9 + 1.0f), new ResultPoint(f4 + 1.0f, f5 + 1.0f), new ResultPoint(f6 - 1.0f, f7 - 1.0f), new ResultPoint(f2 + 1.0f, f3 - 1.0f)};
        }
        return new ResultPoint[]{new ResultPoint(f8 + 1.0f, f9 + 1.0f), new ResultPoint(f4 + 1.0f, f5 - 1.0f), new ResultPoint(f6 - 1.0f, f7 + 1.0f), new ResultPoint(f2 - 1.0f, f3 - 1.0f)};
    }

    private boolean containsBlackPoint(int n, int n2, int n3, boolean bl) {
        if (bl) {
            int n4 = n;
            while (n4 <= n2) {
                if (this.image.get(n4, n3)) {
                    return true;
                }
                ++n4;
            }
        } else {
            int n5 = n;
            while (n5 <= n2) {
                if (this.image.get(n3, n5)) {
                    return true;
                }
                ++n5;
            }
        }
        return false;
    }
}

