/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Arrays;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.ChecksumException;
import oz.util.barcode.FormatException;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.OneDReader;

public final class Code39Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{52, 289, 97, 352, 49, 304, 112, 37, 292, 100, 265, 73, 328, 25, 280, 88, 13, 268, 76, 28, 259, 67, 322, 19, 274, 82, 7, 262, 70, 22, 385, 193, 448, 145, 400, 208, 133, 388, 196, 148, 168, 162, 138, 42};
    private static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[39];
    private final boolean usingCheckDigit;
    private final boolean extendedMode;
    private final StringBuilder decodeRowResult;
    private final int[] counters;

    public Code39Reader() {
        this(false);
    }

    public Code39Reader(boolean bl) {
        this(bl, false);
    }

    public Code39Reader(boolean bl, boolean bl2) {
        this.usingCheckDigit = bl;
        this.extendedMode = bl2;
        this.decodeRowResult = new StringBuilder(20);
        this.counters = new int[9];
    }

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        int n2;
        int n3;
        int n4;
        int[] nArray;
        int n5;
        int n6;
        char c2;
        int[] nArray2 = this.counters;
        Arrays.fill(nArray2, 0);
        StringBuilder stringBuilder = this.decodeRowResult;
        stringBuilder.setLength(0);
        int[] nArray3 = Code39Reader.findAsteriskPattern(bitArray, nArray2);
        int n7 = bitArray.getNextSet(nArray3[1]);
        int n8 = bitArray.getSize();
        do {
            Code39Reader.recordPattern(bitArray, n7, nArray2);
            n6 = Code39Reader.toNarrowWidePattern(nArray2);
            if (n6 < 0) {
                throw NotFoundException.getNotFoundInstance();
            }
            c2 = Code39Reader.patternToChar(n6);
            stringBuilder.append(c2);
            n5 = n7;
            nArray = nArray2;
            n4 = nArray2.length;
            n3 = 0;
            while (n3 < n4) {
                n2 = nArray[n3];
                n7 += n2;
                ++n3;
            }
            n7 = bitArray.getNextSet(n7);
        } while (c2 != '*');
        stringBuilder.setLength(stringBuilder.length() - 1);
        n6 = 0;
        nArray = nArray2;
        n4 = nArray2.length;
        n3 = 0;
        while (n3 < n4) {
            n2 = nArray[n3];
            n6 += n2;
            ++n3;
        }
        n2 = n7 - n5 - n6;
        if (n7 != n8 && n2 >> 1 < n6) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.usingCheckDigit) {
            n3 = stringBuilder.length() - 1;
            n4 = 0;
            int n9 = 0;
            while (n9 < n3) {
                n4 += ALPHABET_STRING.indexOf(this.decodeRowResult.charAt(n9));
                ++n9;
            }
            if (stringBuilder.charAt(n3) != ALPHABET[n4 % 43]) {
                throw ChecksumException.getChecksumInstance();
            }
            stringBuilder.setLength(n3);
        }
        if (stringBuilder.length() == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string = this.extendedMode ? Code39Reader.decodeExtended(stringBuilder) : stringBuilder.toString();
        float f2 = (float)(nArray3[1] + nArray3[0]) / 2.0f;
        float f3 = (float)n5 + (float)n6 / 2.0f;
        return new Result(string, null, new ResultPoint[]{new ResultPoint(f2, n), new ResultPoint(f3, n)}, BarcodeFormat.CODE_39);
    }

    private static int[] findAsteriskPattern(BitArray bitArray, int[] nArray) {
        int n = bitArray.getSize();
        int n2 = bitArray.getNextSet(0);
        int n3 = 0;
        int n4 = n2;
        boolean bl = false;
        int n5 = nArray.length;
        int n6 = n2;
        while (n6 < n) {
            if (bitArray.get(n6) ^ bl) {
                int n7 = n3;
                nArray[n7] = nArray[n7] + 1;
            } else {
                if (n3 == n5 - 1) {
                    if (Code39Reader.toNarrowWidePattern(nArray) == ASTERISK_ENCODING && bitArray.isRange(Math.max(0, n4 - (n6 - n4 >> 1)), n4, false)) {
                        return new int[]{n4, n6};
                    }
                    n4 += nArray[0] + nArray[1];
                    System.arraycopy(nArray, 2, nArray, 0, n5 - 2);
                    nArray[n5 - 2] = 0;
                    nArray[n5 - 1] = 0;
                    --n3;
                } else {
                    ++n3;
                }
                nArray[n3] = 1;
                bl = !bl;
            }
            ++n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toNarrowWidePattern(int[] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = 0;
        do {
            int n4;
            int n5 = Integer.MAX_VALUE;
            int[] nArray2 = nArray;
            int n6 = nArray.length;
            int n7 = 0;
            while (n7 < n6) {
                n4 = nArray2[n7];
                if (n4 < n5 && n4 > n3) {
                    n5 = n4;
                }
                ++n7;
            }
            n3 = n5;
            n = 0;
            n4 = 0;
            n7 = 0;
            n6 = 0;
            while (n6 < n2) {
                int n8 = nArray[n6];
                if (n8 > n3) {
                    n7 |= 1 << n2 - 1 - n6;
                    ++n;
                    n4 += n8;
                }
                ++n6;
            }
            if (n != 3) continue;
            n6 = 0;
            while (n6 < n2 && n > 0) {
                int n9 = nArray[n6];
                if (n9 > n3) {
                    --n;
                    if (n9 << 1 >= n4) {
                        return -1;
                    }
                }
                ++n6;
            }
            return n7;
        } while (n > 3);
        return -1;
    }

    private static char patternToChar(int n) {
        int n2 = 0;
        while (n2 < CHARACTER_ENCODINGS.length) {
            if (CHARACTER_ENCODINGS[n2] == n) {
                return ALPHABET[n2];
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(CharSequence charSequence) {
        int n = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            char c2 = charSequence.charAt(n2);
            if (c2 == '+' || c2 == '$' || c2 == '%' || c2 == '/') {
                char c3 = charSequence.charAt(n2 + 1);
                int n3 = 0;
                switch (c2) {
                    case '+': {
                        if (c3 >= 'A' && c3 <= 'Z') {
                            n3 = (char)(c3 + 32);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '$': {
                        if (c3 >= 'A' && c3 <= 'Z') {
                            n3 = (char)(c3 - 64);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '%': {
                        if (c3 >= 'A' && c3 <= 'E') {
                            n3 = (char)(c3 - 38);
                            break;
                        }
                        if (c3 >= 'F' && c3 <= 'W') {
                            n3 = (char)(c3 - 11);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '/': {
                        if (c3 >= 'A' && c3 <= 'O') {
                            n3 = (char)(c3 - 32);
                            break;
                        }
                        if (c3 == 'Z') {
                            n3 = 58;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
                stringBuilder.append((char)n3);
                ++n2;
            } else {
                stringBuilder.append(c2);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }
}

