/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.UPCEANReader;

public final class UPCEReader
extends UPCEANReader {
    private static final int[] MIDDLE_END_PATTERN = new int[]{1, 1, 1, 1, 1, 1};
    private static final int[][] NUMSYS_AND_CHECK_DIGIT_PATTERNS = new int[][]{{56, 52, 50, 49, 44, 38, 35, 42, 41, 37}, {7, 11, 13, 14, 19, 25, 28, 21, 22, 26}};
    private final int[] decodeMiddleCounters = new int[4];

    @Override
    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) {
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n = bitArray.getSize();
        int n2 = nArray[1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < 6 && n2 < n) {
            int n5 = UPCEReader.decodeDigit(bitArray, nArray2, n2, L_AND_G_PATTERNS);
            stringBuilder.append((char)(48 + n5 % 10));
            int[] nArray3 = nArray2;
            int n6 = nArray2.length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = nArray3[n7];
                n2 += n8;
                ++n7;
            }
            if (n5 >= 10) {
                n3 |= 1 << 5 - n4;
            }
            ++n4;
        }
        UPCEReader.determineNumSysAndCheckDigit(stringBuilder, n3);
        return n2;
    }

    @Override
    protected int[] decodeEnd(BitArray bitArray, int n) {
        return UPCEReader.findGuardPattern(bitArray, n, true, MIDDLE_END_PATTERN);
    }

    @Override
    protected boolean checkChecksum(String string) {
        return super.checkChecksum(UPCEReader.convertUPCEtoUPCA(string));
    }

    private static void determineNumSysAndCheckDigit(StringBuilder stringBuilder, int n) {
        int n2 = 0;
        while (n2 <= 1) {
            int n3 = 0;
            while (n3 < 10) {
                if (n == NUMSYS_AND_CHECK_DIGIT_PATTERNS[n2][n3]) {
                    stringBuilder.insert(0, (char)(48 + n2));
                    stringBuilder.append((char)(48 + n3));
                    return;
                }
                ++n3;
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.UPC_E;
    }

    public static String convertUPCEtoUPCA(String string) {
        char[] cArray = new char[6];
        string.getChars(1, 7, cArray, 0);
        StringBuilder stringBuilder = new StringBuilder(12);
        stringBuilder.append(string.charAt(0));
        char c2 = cArray[5];
        switch (c2) {
            case '0': 
            case '1': 
            case '2': {
                stringBuilder.append(cArray, 0, 2);
                stringBuilder.append(c2);
                stringBuilder.append("0000");
                stringBuilder.append(cArray, 2, 3);
                break;
            }
            case '3': {
                stringBuilder.append(cArray, 0, 3);
                stringBuilder.append("00000");
                stringBuilder.append(cArray, 3, 2);
                break;
            }
            case '4': {
                stringBuilder.append(cArray, 0, 4);
                stringBuilder.append("00000");
                stringBuilder.append(cArray[4]);
                break;
            }
            default: {
                stringBuilder.append(cArray, 0, 5);
                stringBuilder.append("0000");
                stringBuilder.append(c2);
            }
        }
        stringBuilder.append(string.charAt(7));
        return stringBuilder.toString();
    }
}

