/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned.rss.expanded;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.rss.AbstractRSSReader;
import oz.util.barcode.oned.rss.DataCharacter;
import oz.util.barcode.oned.rss.FinderPattern;
import oz.util.barcode.oned.rss.RSSUtils;
import oz.util.barcode.oned.rss.expanded.BitArrayBuilder;
import oz.util.barcode.oned.rss.expanded.ExpandedPair;
import oz.util.barcode.oned.rss.expanded.ExpandedRow;
import oz.util.barcode.oned.rss.expanded.decoders.AbstractExpandedDecoder;

public final class RSSExpandedReader
extends AbstractRSSReader {
    private static final int[] SYMBOL_WIDEST = new int[]{7, 5, 4, 3, 1};
    private static final int[] EVEN_TOTAL_SUBSET = new int[]{4, 20, 52, 104, 204};
    private static final int[] GSUM;
    private static final int[][] FINDER_PATTERNS;
    private static final int[][] WEIGHTS;
    private static final int FINDER_PAT_A = 0;
    private static final int FINDER_PAT_B = 1;
    private static final int FINDER_PAT_C = 2;
    private static final int FINDER_PAT_D = 3;
    private static final int FINDER_PAT_E = 4;
    private static final int FINDER_PAT_F = 5;
    private static final int[][] FINDER_PATTERN_SEQUENCES;
    private static final int MAX_PAIRS = 11;
    private final List pairs = new ArrayList(11);
    private final List rows = new ArrayList();
    private final int[] startEnd = new int[2];
    private boolean startFromEven = false;

    static {
        int[] nArray = new int[5];
        nArray[1] = 348;
        nArray[2] = 1388;
        nArray[3] = 2948;
        nArray[4] = 3988;
        GSUM = nArray;
        FINDER_PATTERNS = new int[][]{{1, 8, 4, 1}, {3, 6, 4, 1}, {3, 4, 6, 1}, {3, 2, 8, 1}, {2, 6, 5, 1}, {2, 2, 9, 1}};
        WEIGHTS = new int[][]{{1, 3, 9, 27, 81, 32, 96, 77}, {20, 60, 180, 118, 143, 7, 21, 63}, {189, 145, 13, 39, 117, 140, 209, 205}, {193, 157, 49, 147, 19, 57, 171, 91}, {62, 186, 136, 197, 169, 85, 44, 132}, {185, 133, 188, 142, 4, 12, 36, 108}, {113, 128, 173, 97, 80, 29, 87, 50}, {150, 28, 84, 41, 123, 158, 52, 156}, {46, 138, 203, 187, 139, 206, 196, 166}, {76, 17, 51, 153, 37, 111, 122, 155}, {43, 129, 176, 106, 107, 110, 119, 146}, {16, 48, 144, 10, 30, 90, 59, 177}, {109, 116, 137, 200, 178, 112, 125, 164}, {70, 210, 208, 202, 184, 130, 179, 115}, {134, 191, 151, 31, 93, 68, 204, 190}, {148, 22, 66, 198, 172, 94, 71, 2}, {6, 18, 54, 162, 64, 192, 154, 40}, {120, 149, 25, 75, 14, 42, 126, 167}, {79, 26, 78, 23, 69, 207, 199, 175}, {103, 98, 83, 38, 114, 131, 182, 124}, {161, 61, 183, 127, 170, 88, 53, 159}, {55, 165, 73, 8, 24, 72, 5, 15}, {45, 135, 194, 160, 58, 174, 100, 89}};
        int[][] nArrayArray = new int[10][];
        nArrayArray[0] = new int[2];
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 2;
        nArray3[2] = 1;
        nArray3[3] = 3;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[1] = 4;
        nArray4[2] = 1;
        nArray4[3] = 3;
        nArray4[4] = 2;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[6];
        nArray5[1] = 4;
        nArray5[2] = 1;
        nArray5[3] = 3;
        nArray5[4] = 3;
        nArray5[5] = 5;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[7];
        nArray6[1] = 4;
        nArray6[2] = 1;
        nArray6[3] = 3;
        nArray6[4] = 4;
        nArray6[5] = 5;
        nArray6[6] = 5;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[8];
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[4] = 2;
        nArray7[5] = 2;
        nArray7[6] = 3;
        nArray7[7] = 3;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[9];
        nArray8[2] = 1;
        nArray8[3] = 1;
        nArray8[4] = 2;
        nArray8[5] = 2;
        nArray8[6] = 3;
        nArray8[7] = 4;
        nArray8[8] = 4;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[10];
        nArray9[2] = 1;
        nArray9[3] = 1;
        nArray9[4] = 2;
        nArray9[5] = 2;
        nArray9[6] = 3;
        nArray9[7] = 4;
        nArray9[8] = 5;
        nArray9[9] = 5;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[11];
        nArray10[2] = 1;
        nArray10[3] = 1;
        nArray10[4] = 2;
        nArray10[5] = 3;
        nArray10[6] = 3;
        nArray10[7] = 4;
        nArray10[8] = 4;
        nArray10[9] = 5;
        nArray10[10] = 5;
        nArrayArray[9] = nArray10;
        FINDER_PATTERN_SEQUENCES = nArrayArray;
    }

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        this.pairs.clear();
        this.startFromEven = false;
        try {
            List list = this.decodeRow2pairs(n, bitArray);
            return RSSExpandedReader.constructResult(list);
        }
        catch (NotFoundException notFoundException) {
            this.pairs.clear();
            this.startFromEven = true;
            List list = this.decodeRow2pairs(n, bitArray);
            return RSSExpandedReader.constructResult(list);
        }
    }

    @Override
    public void reset() {
        this.pairs.clear();
        this.rows.clear();
    }

    List decodeRow2pairs(int n, BitArray bitArray) {
        try {
            while (true) {
                ExpandedPair expandedPair = this.retrieveNextPair(bitArray, this.pairs, n);
                this.pairs.add(expandedPair);
            }
        }
        catch (NotFoundException notFoundException) {
            if (this.pairs.isEmpty()) {
                throw notFoundException;
            }
            if (this.checkChecksum()) {
                return this.pairs;
            }
            boolean bl = !this.rows.isEmpty();
            boolean bl2 = false;
            this.storeRow(n, bl2);
            if (bl) {
                List list = this.checkRows(false);
                if (list != null) {
                    return list;
                }
                list = this.checkRows(true);
                if (list != null) {
                    return list;
                }
            }
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private List checkRows(boolean bl) {
        if (this.rows.size() > 25) {
            this.rows.clear();
            return null;
        }
        this.pairs.clear();
        if (bl) {
            Collections.reverse(this.rows);
        }
        List list = null;
        try {
            list = this.checkRows(new ArrayList(), 0);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (bl) {
            Collections.reverse(this.rows);
        }
        return list;
    }

    private List checkRows(List list, int n) {
        int n2 = n;
        while (n2 < this.rows.size()) {
            ExpandedRow expandedRow = (ExpandedRow)this.rows.get(n2);
            this.pairs.clear();
            int n3 = list.size();
            int n4 = 0;
            while (n4 < n3) {
                this.pairs.addAll(((ExpandedRow)list.get(n4)).getPairs());
                ++n4;
            }
            this.pairs.addAll(expandedRow.getPairs());
            if (RSSExpandedReader.isValidSequence(this.pairs)) {
                if (this.checkChecksum()) {
                    return this.pairs;
                }
                ArrayList<ExpandedRow> arrayList = new ArrayList<ExpandedRow>();
                arrayList.addAll(list);
                arrayList.add(expandedRow);
                try {
                    return this.checkRows(arrayList, n2 + 1);
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static boolean isValidSequence(List list) {
        int[][] nArray = FINDER_PATTERN_SEQUENCES;
        int n = FINDER_PATTERN_SEQUENCES.length;
        int n2 = 0;
        while (n2 < n) {
            int[] nArray2 = nArray[n2];
            if (list.size() <= nArray2.length) {
                boolean bl = true;
                int n3 = 0;
                while (n3 < list.size()) {
                    if (((ExpandedPair)list.get(n3)).getFinderPattern().getValue() != nArray2[n3]) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private void storeRow(int n, boolean bl) {
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n2 < this.rows.size()) {
            ExpandedRow expandedRow = (ExpandedRow)this.rows.get(n2);
            if (expandedRow.getRowNumber() > n) {
                bl3 = expandedRow.isEquivalent(this.pairs);
                break;
            }
            bl2 = expandedRow.isEquivalent(this.pairs);
            ++n2;
        }
        if (bl3 || bl2) {
            return;
        }
        if (RSSExpandedReader.isPartialRow(this.pairs, this.rows)) {
            return;
        }
        this.rows.add(n2, new ExpandedRow(this.pairs, n, bl));
        RSSExpandedReader.removePartialRows(this.pairs, this.rows);
    }

    private static void removePartialRows(List list, List list2) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ExpandedRow expandedRow = (ExpandedRow)iterator.next();
            if (expandedRow.getPairs().size() == list.size()) continue;
            boolean bl = true;
            for (ExpandedPair expandedPair : expandedRow.getPairs()) {
                boolean bl2 = false;
                for (ExpandedPair expandedPair2 : list) {
                    if (!expandedPair.equals(expandedPair2)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            iterator.remove();
        }
    }

    private static boolean isPartialRow(Iterable iterable, Iterable iterable2) {
        for (ExpandedRow expandedRow : iterable2) {
            boolean bl = true;
            for (ExpandedPair expandedPair : iterable) {
                boolean bl2 = false;
                for (ExpandedPair expandedPair2 : expandedRow.getPairs()) {
                    if (!expandedPair.equals(expandedPair2)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    List getRows() {
        return this.rows;
    }

    static Result constructResult(List list) {
        BitArray bitArray = BitArrayBuilder.buildBitArray(list);
        AbstractExpandedDecoder abstractExpandedDecoder = AbstractExpandedDecoder.createDecoder(bitArray);
        String string = abstractExpandedDecoder.parseInformation();
        ResultPoint[] resultPointArray = ((ExpandedPair)list.get(0)).getFinderPattern().getResultPoints();
        ResultPoint[] resultPointArray2 = ((ExpandedPair)list.get(list.size() - 1)).getFinderPattern().getResultPoints();
        return new Result(string, null, new ResultPoint[]{resultPointArray[0], resultPointArray[1], resultPointArray2[0], resultPointArray2[1]}, BarcodeFormat.RSS_EXPANDED);
    }

    private boolean checkChecksum() {
        ExpandedPair expandedPair = (ExpandedPair)this.pairs.get(0);
        DataCharacter dataCharacter = expandedPair.getLeftChar();
        DataCharacter dataCharacter2 = expandedPair.getRightChar();
        if (dataCharacter2 == null) {
            return false;
        }
        int n = dataCharacter2.getChecksumPortion();
        int n2 = 2;
        int n3 = 1;
        while (n3 < this.pairs.size()) {
            ExpandedPair expandedPair2 = (ExpandedPair)this.pairs.get(n3);
            n += expandedPair2.getLeftChar().getChecksumPortion();
            ++n2;
            DataCharacter dataCharacter3 = expandedPair2.getRightChar();
            if (dataCharacter3 != null) {
                n += dataCharacter3.getChecksumPortion();
                ++n2;
            }
            ++n3;
        }
        n3 = 211 * (n2 - 4) + (n %= 211);
        return n3 == dataCharacter.getValue();
    }

    private static int getNextSecondBar(BitArray bitArray, int n) {
        int n2;
        if (bitArray.get(n)) {
            n2 = bitArray.getNextUnset(n);
            n2 = bitArray.getNextSet(n2);
        } else {
            n2 = bitArray.getNextSet(n);
            n2 = bitArray.getNextUnset(n2);
        }
        return n2;
    }

    ExpandedPair retrieveNextPair(BitArray bitArray, List list, int n) {
        DataCharacter dataCharacter;
        FinderPattern finderPattern;
        boolean bl;
        boolean bl2 = bl = list.size() % 2 == 0;
        if (this.startFromEven) {
            bl = !bl;
        }
        boolean bl3 = true;
        int n2 = -1;
        do {
            this.findNextPair(bitArray, list, n2);
            finderPattern = this.parseFoundFinderPattern(bitArray, n, bl);
            if (finderPattern == null) {
                n2 = RSSExpandedReader.getNextSecondBar(bitArray, this.startEnd[0]);
                continue;
            }
            bl3 = false;
        } while (bl3);
        DataCharacter dataCharacter2 = this.decodeDataCharacter(bitArray, finderPattern, bl, true);
        if (!list.isEmpty() && ((ExpandedPair)list.get(list.size() - 1)).mustBeLast()) {
            throw NotFoundException.getNotFoundInstance();
        }
        try {
            dataCharacter = this.decodeDataCharacter(bitArray, finderPattern, bl, false);
        }
        catch (NotFoundException notFoundException) {
            dataCharacter = null;
        }
        boolean bl4 = true;
        return new ExpandedPair(dataCharacter2, dataCharacter, finderPattern, bl4);
    }

    private void findNextPair(BitArray bitArray, List list, int n) {
        boolean bl;
        int n2;
        int[] nArray = this.getDecodeFinderCounters();
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        int n3 = bitArray.getSize();
        if (n >= 0) {
            n2 = n;
        } else if (list.isEmpty()) {
            n2 = 0;
        } else {
            ExpandedPair expandedPair = (ExpandedPair)list.get(list.size() - 1);
            n2 = expandedPair.getFinderPattern().getStartEnd()[1];
        }
        boolean bl2 = bl = list.size() % 2 != 0;
        if (this.startFromEven) {
            bl = !bl;
        }
        boolean bl3 = false;
        while (n2 < n3) {
            boolean bl4 = bl3 = !bitArray.get(n2);
            if (!bl3) break;
            ++n2;
        }
        int n4 = 0;
        int n5 = n2;
        int n6 = n2;
        while (n6 < n3) {
            if (bitArray.get(n6) ^ bl3) {
                int n7 = n4;
                nArray[n7] = nArray[n7] + 1;
            } else {
                if (n4 == 3) {
                    if (bl) {
                        RSSExpandedReader.reverseCounters(nArray);
                    }
                    if (RSSExpandedReader.isFinderPattern(nArray)) {
                        this.startEnd[0] = n5;
                        this.startEnd[1] = n6;
                        return;
                    }
                    if (bl) {
                        RSSExpandedReader.reverseCounters(nArray);
                    }
                    n5 += nArray[0] + nArray[1];
                    nArray[0] = nArray[2];
                    nArray[1] = nArray[3];
                    nArray[2] = 0;
                    nArray[3] = 0;
                    --n4;
                } else {
                    ++n4;
                }
                nArray[n4] = 1;
                bl3 = !bl3;
            }
            ++n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static void reverseCounters(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n / 2) {
            int n3 = nArray[n2];
            nArray[n2] = nArray[n - n2 - 1];
            nArray[n - n2 - 1] = n3;
            ++n2;
        }
    }

    private FinderPattern parseFoundFinderPattern(BitArray bitArray, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (bl) {
            int n6 = this.startEnd[0] - 1;
            while (n6 >= 0 && !bitArray.get(n6)) {
                --n6;
            }
            n5 = this.startEnd[0] - ++n6;
            n4 = n6;
            n3 = this.startEnd[1];
        } else {
            n4 = this.startEnd[0];
            n3 = bitArray.getNextUnset(this.startEnd[1] + 1);
            n5 = n3 - this.startEnd[1];
        }
        int[] nArray = this.getDecodeFinderCounters();
        System.arraycopy(nArray, 0, nArray, 1, nArray.length - 1);
        nArray[0] = n5;
        try {
            n2 = RSSExpandedReader.parseFinderValue(nArray, FINDER_PATTERNS);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
        return new FinderPattern(n2, new int[]{n4, n3}, n4, n3, n);
    }

    DataCharacter decodeDataCharacter(BitArray bitArray, FinderPattern finderPattern, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = this.getDataCharacterCounters();
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        if (bl2) {
            RSSExpandedReader.recordPatternInReverse(bitArray, finderPattern.getStartEnd()[0], nArray);
        } else {
            RSSExpandedReader.recordPattern(bitArray, finderPattern.getStartEnd()[1], nArray);
            n5 = 0;
            int n6 = nArray.length - 1;
            while (n5 < n6) {
                int n7 = nArray[n5];
                nArray[n5] = nArray[n6];
                nArray[n6] = n7;
                ++n5;
                --n6;
            }
        }
        n5 = 17;
        float f2 = (float)RSSExpandedReader.count(nArray) / (float)n5;
        float f3 = (float)(finderPattern.getStartEnd()[1] - finderPattern.getStartEnd()[0]) / 15.0f;
        if (Math.abs(f2 - f3) / f3 > 0.3f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int[] nArray2 = this.getOddCounts();
        int[] nArray3 = this.getEvenCounts();
        float[] fArray = this.getOddRoundingErrors();
        float[] fArray2 = this.getEvenRoundingErrors();
        int n8 = 0;
        while (n8 < nArray.length) {
            float f4 = 1.0f * (float)nArray[n8] / f2;
            n4 = (int)(f4 + 0.5f);
            if (n4 < 1) {
                if (f4 < 0.3f) {
                    throw NotFoundException.getNotFoundInstance();
                }
                n4 = 1;
            } else if (n4 > 8) {
                if (f4 > 8.7f) {
                    throw NotFoundException.getNotFoundInstance();
                }
                n4 = 8;
            }
            n3 = n8 >> 1;
            if ((n8 & 1) == 0) {
                nArray2[n3] = n4;
                fArray[n3] = f4 - (float)n4;
            } else {
                nArray3[n3] = n4;
                fArray2[n3] = f4 - (float)n4;
            }
            ++n8;
        }
        this.adjustOddEvenCounts(n5);
        n8 = 4 * finderPattern.getValue() + (bl ? 0 : 2) + (bl2 ? 0 : 1) - 1;
        int n9 = 0;
        n4 = 0;
        n3 = nArray2.length - 1;
        while (n3 >= 0) {
            if (RSSExpandedReader.isNotA1left(finderPattern, bl, bl2)) {
                n2 = WEIGHTS[n8][2 * n3];
                n4 += nArray2[n3] * n2;
            }
            n9 += nArray2[n3];
            --n3;
        }
        n3 = 0;
        n2 = nArray3.length - 1;
        while (n2 >= 0) {
            if (RSSExpandedReader.isNotA1left(finderPattern, bl, bl2)) {
                n = WEIGHTS[n8][2 * n2 + 1];
                n3 += nArray3[n2] * n;
            }
            --n2;
        }
        n2 = n4 + n3;
        if ((n9 & 1) != 0 || n9 > 13 || n9 < 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        n = (13 - n9) / 2;
        int n10 = SYMBOL_WIDEST[n];
        int n11 = 9 - n10;
        int n12 = RSSUtils.getRSSvalue(nArray2, n10, true);
        int n13 = RSSUtils.getRSSvalue(nArray3, n11, false);
        int n14 = EVEN_TOTAL_SUBSET[n];
        int n15 = GSUM[n];
        int n16 = n12 * n14 + n13 + n15;
        return new DataCharacter(n16, n2);
    }

    private static boolean isNotA1left(FinderPattern finderPattern, boolean bl, boolean bl2) {
        return finderPattern.getValue() != 0 || !bl || !bl2;
    }

    private void adjustOddEvenCounts(int n) {
        int n2 = RSSExpandedReader.count(this.getOddCounts());
        int n3 = RSSExpandedReader.count(this.getEvenCounts());
        int n4 = n2 + n3 - n;
        boolean bl = (n2 & 1) == 1;
        boolean bl2 = (n3 & 1) == 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n2 > 13) {
            bl4 = true;
        } else if (n2 < 4) {
            bl3 = true;
        }
        boolean bl5 = false;
        boolean bl6 = false;
        if (n3 > 13) {
            bl6 = true;
        } else if (n3 < 4) {
            bl5 = true;
        }
        if (n4 == 1) {
            if (bl) {
                if (bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl4 = true;
            } else {
                if (!bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl6 = true;
            }
        } else if (n4 == -1) {
            if (bl) {
                if (bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl3 = true;
            } else {
                if (!bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl5 = true;
            }
        } else if (n4 == 0) {
            if (bl) {
                if (!bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (n2 < n3) {
                    bl3 = true;
                    bl6 = true;
                } else {
                    bl4 = true;
                    bl5 = true;
                }
            } else if (bl2) {
                throw NotFoundException.getNotFoundInstance();
            }
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        if (bl3) {
            if (bl4) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (bl4) {
            RSSExpandedReader.decrement(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (bl5) {
            if (bl6) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.getEvenCounts(), this.getOddRoundingErrors());
        }
        if (bl6) {
            RSSExpandedReader.decrement(this.getEvenCounts(), this.getEvenRoundingErrors());
        }
    }
}

