/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.decoder.ec;

import oz.util.barcode.ChecksumException;
import oz.util.barcode.pdf417.decoder.ec.ModulusGF;
import oz.util.barcode.pdf417.decoder.ec.ModulusPoly;

public final class ErrorCorrection {
    private final ModulusGF field = ModulusGF.PDF417_GF;

    public int decode(int[] nArray, int n, int[] nArray2) {
        Object object;
        Object object2;
        int n2;
        ModulusPoly modulusPoly = new ModulusPoly(this.field, nArray);
        int[] nArray3 = new int[n];
        boolean bl = false;
        int n3 = n;
        while (n3 > 0) {
            nArray3[n - n3] = n2 = modulusPoly.evaluateAt(this.field.exp(n3));
            if (n2 != 0) {
                bl = true;
            }
            --n3;
        }
        if (!bl) {
            return 0;
        }
        ModulusPoly modulusPoly2 = this.field.getOne();
        if (nArray2 != null) {
            object2 = nArray2;
            int n4 = nArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                n2 = object2[n5];
                int n6 = this.field.exp(nArray.length - 1 - n2);
                object = new ModulusPoly(this.field, new int[]{this.field.subtract(0, n6), 1});
                modulusPoly2 = modulusPoly2.multiply((ModulusPoly)object);
                ++n5;
            }
        }
        ModulusPoly modulusPoly3 = new ModulusPoly(this.field, nArray3);
        ModulusPoly[] modulusPolyArray = this.runEuclideanAlgorithm(this.field.buildMonomial(n, 1), modulusPoly3, n);
        ModulusPoly modulusPoly4 = modulusPolyArray[0];
        object2 = modulusPolyArray[1];
        int[] nArray4 = this.findErrorLocations(modulusPoly4);
        object = this.findErrorMagnitudes((ModulusPoly)object2, modulusPoly4, nArray4);
        int n7 = 0;
        while (n7 < nArray4.length) {
            int n8 = nArray.length - 1 - this.field.log(nArray4[n7]);
            if (n8 < 0) {
                throw ChecksumException.getChecksumInstance();
            }
            nArray[n8] = this.field.subtract(nArray[n8], object[n7]);
            ++n7;
        }
        return nArray4.length;
    }

    private ModulusPoly[] runEuclideanAlgorithm(ModulusPoly modulusPoly, ModulusPoly modulusPoly2, int n) {
        ModulusPoly modulusPoly3;
        ModulusPoly modulusPoly4;
        if (modulusPoly.getDegree() < modulusPoly2.getDegree()) {
            modulusPoly4 = modulusPoly;
            modulusPoly = modulusPoly2;
            modulusPoly2 = modulusPoly4;
        }
        modulusPoly4 = modulusPoly;
        ModulusPoly modulusPoly5 = modulusPoly2;
        ModulusPoly modulusPoly6 = this.field.getZero();
        ModulusPoly modulusPoly7 = this.field.getOne();
        while (modulusPoly5.getDegree() >= n / 2) {
            ModulusPoly modulusPoly8 = modulusPoly4;
            ModulusPoly modulusPoly9 = modulusPoly6;
            modulusPoly4 = modulusPoly5;
            modulusPoly6 = modulusPoly7;
            if (modulusPoly4.isZero()) {
                throw ChecksumException.getChecksumInstance();
            }
            modulusPoly5 = modulusPoly8;
            modulusPoly3 = this.field.getZero();
            int n2 = modulusPoly4.getCoefficient(modulusPoly4.getDegree());
            int n3 = this.field.inverse(n2);
            while (modulusPoly5.getDegree() >= modulusPoly4.getDegree() && !modulusPoly5.isZero()) {
                int n4 = modulusPoly5.getDegree() - modulusPoly4.getDegree();
                int n5 = this.field.multiply(modulusPoly5.getCoefficient(modulusPoly5.getDegree()), n3);
                modulusPoly3 = modulusPoly3.add(this.field.buildMonomial(n4, n5));
                modulusPoly5 = modulusPoly5.subtract(modulusPoly4.multiplyByMonomial(n4, n5));
            }
            modulusPoly7 = modulusPoly3.multiply(modulusPoly6).subtract(modulusPoly9).negative();
        }
        int n6 = modulusPoly7.getCoefficient(0);
        if (n6 == 0) {
            throw ChecksumException.getChecksumInstance();
        }
        int n7 = this.field.inverse(n6);
        modulusPoly3 = modulusPoly7.multiply(n7);
        ModulusPoly modulusPoly10 = modulusPoly5.multiply(n7);
        return new ModulusPoly[]{modulusPoly3, modulusPoly10};
    }

    private int[] findErrorLocations(ModulusPoly modulusPoly) {
        int n = modulusPoly.getDegree();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 1;
        while (n3 < this.field.getSize() && n2 < n) {
            if (modulusPoly.evaluateAt(n3) == 0) {
                nArray[n2] = this.field.inverse(n3);
                ++n2;
            }
            ++n3;
        }
        if (n2 != n) {
            throw ChecksumException.getChecksumInstance();
        }
        return nArray;
    }

    private int[] findErrorMagnitudes(ModulusPoly modulusPoly, ModulusPoly modulusPoly2, int[] nArray) {
        int n = modulusPoly2.getDegree();
        int[] nArray2 = new int[n];
        int n2 = 1;
        while (n2 <= n) {
            nArray2[n - n2] = this.field.multiply(n2, modulusPoly2.getCoefficient(n2));
            ++n2;
        }
        ModulusPoly modulusPoly3 = new ModulusPoly(this.field, nArray2);
        int n3 = nArray.length;
        int[] nArray3 = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.field.inverse(nArray[n4]);
            int n6 = this.field.subtract(0, modulusPoly.evaluateAt(n5));
            int n7 = this.field.inverse(modulusPoly3.evaluateAt(n5));
            nArray3[n4] = this.field.multiply(n6, n7);
            ++n4;
        }
        return nArray3;
    }
}

