/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode;

import java.util.List;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Reader;
import oz.util.barcode.Result;
import oz.util.barcode.ResultMetadataType;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.common.DetectorResult;
import oz.util.barcode.qrcode.decoder.Decoder;
import oz.util.barcode.qrcode.decoder.QRCodeDecoderMetaData;
import oz.util.barcode.qrcode.detector.Detector;

public class QRCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    protected final Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public final Result decode(BinaryBitmap binaryBitmap, Map map) {
        String string;
        ResultPoint[] resultPointArray;
        DecoderResult decoderResult;
        Object object;
        if (map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            object = QRCodeReader.extractPureBits(binaryBitmap.getBlackMatrix());
            decoderResult = this.decoder.decode((BitMatrix)object, map);
            resultPointArray = NO_POINTS;
        } else {
            object = new Detector(binaryBitmap.getBlackMatrix()).detect(map);
            decoderResult = this.decoder.decode(((DetectorResult)object).getBits(), map);
            resultPointArray = ((DetectorResult)object).getPoints();
        }
        if (decoderResult.getOther() instanceof QRCodeDecoderMetaData) {
            ((QRCodeDecoderMetaData)decoderResult.getOther()).applyMirroredCorrection(resultPointArray);
        }
        object = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.QR_CODE);
        List list = decoderResult.getByteSegments();
        if (list != null) {
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, list);
        }
        if ((string = decoderResult.getECLevel()) != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string);
        }
        if (decoderResult.hasStructuredAppend()) {
            ((Result)object).putMetadata(ResultMetadataType.STRUCTURED_APPEND_SEQUENCE, decoderResult.getStructuredAppendSequenceNumber());
            ((Result)object).putMetadata(ResultMetadataType.STRUCTURED_APPEND_PARITY, decoderResult.getStructuredAppendParity());
        }
        return object;
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) {
        int n;
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray == null || nArray2 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        float f2 = QRCodeReader.moduleSize(nArray, bitMatrix);
        int n2 = nArray[1];
        int n3 = nArray2[1];
        int n4 = nArray[0];
        int n5 = nArray2[0];
        if (n4 >= n5 || n2 >= n3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n3 - n2 != n5 - n4) {
            n5 = n4 + (n3 - n2);
        }
        int n6 = Math.round((float)(n5 - n4 + 1) / f2);
        int n7 = Math.round((float)(n3 - n2 + 1) / f2);
        if (n6 <= 0 || n7 <= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n7 != n6) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n8 = (int)(f2 / 2.0f);
        n2 += n8;
        int n9 = (n4 += n8) + (int)((float)(n6 - 1) * f2) - (n5 - 1);
        if (n9 > 0) {
            if (n9 > n8) {
                throw NotFoundException.getNotFoundInstance();
            }
            n4 -= n9;
        }
        if ((n = n2 + (int)((float)(n7 - 1) * f2) - (n3 - 1)) > 0) {
            if (n > n8) {
                throw NotFoundException.getNotFoundInstance();
            }
            n2 -= n;
        }
        BitMatrix bitMatrix2 = new BitMatrix(n6, n7);
        int n10 = 0;
        while (n10 < n7) {
            int n11 = n2 + (int)((float)n10 * f2);
            int n12 = 0;
            while (n12 < n6) {
                if (bitMatrix.get(n4 + (int)((float)n12 * f2), n11)) {
                    bitMatrix2.set(n12, n10);
                }
                ++n12;
            }
            ++n10;
        }
        return bitMatrix2;
    }

    private static float moduleSize(int[] nArray, BitMatrix bitMatrix) {
        int n = bitMatrix.getHeight();
        int n2 = bitMatrix.getWidth();
        int n3 = nArray[0];
        int n4 = nArray[1];
        boolean bl = true;
        int n5 = 0;
        while (n3 < n2 && n4 < n) {
            if (bl != bitMatrix.get(n3, n4)) {
                if (++n5 == 5) break;
                bl = !bl;
            }
            ++n3;
            ++n4;
        }
        if (n3 == n2 || n4 == n) {
            throw NotFoundException.getNotFoundInstance();
        }
        return (float)(n3 - nArray[0]) / 7.0f;
    }
}

