/*
 * Decompiled with CFR 0.152.
 */
package oz.util.gif;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import oz.util.gif.GifDecoder;
import oz.util.gif.GifImageView$1;
import oz.util.gif.GifImageView$2;
import oz.util.gif.GifImageView$OnAnimationStart;
import oz.util.gif.GifImageView$OnAnimationStop;
import oz.util.gif.GifImageView$OnFrameAvailable;
import oz.util.gif.GifImageView$OnFrameChangeListener;

public class GifImageView
extends ImageView
implements Runnable {
    private static final String TAG = "GifDecoderView";
    private GifDecoder gifDecoder;
    private Bitmap tmpBitmap;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private boolean animating;
    private boolean renderFrame;
    private boolean shouldClear;
    private Thread animationThread;
    private GifImageView$OnFrameAvailable frameCallback = null;
    private long framesDisplayDuration = -1L;
    private GifImageView$OnAnimationStop animationStopCallback = null;
    private GifImageView$OnAnimationStart animationStartCallback = null;
    private GifImageView$OnFrameChangeListener mOnFrameChangeListener;
    private final Runnable updateResults = new GifImageView$1(this);
    private final Runnable cleanupRunnable = new GifImageView$2(this);

    public GifImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public GifImageView(Context context) {
        super(context);
    }

    public void setOnFrameChangeListener(GifImageView$OnFrameChangeListener gifImageView$OnFrameChangeListener) {
        this.mOnFrameChangeListener = gifImageView$OnFrameChangeListener;
    }

    public void setBytes(byte[] byArray) {
        this.gifDecoder = new GifDecoder();
        try {
            this.gifDecoder.read(byArray);
        }
        catch (Exception exception) {
            this.gifDecoder = null;
            Log.e((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            return;
        }
        if (this.animating) {
            this.startAnimationThread();
        } else {
            this.gotoFrame(0);
        }
    }

    public long getFramesDisplayDuration() {
        return this.framesDisplayDuration;
    }

    public void setFramesDisplayDuration(long l) {
        this.framesDisplayDuration = l;
    }

    public void startAnimation() {
        this.animating = true;
        this.startAnimationThread();
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void stopAnimation() {
        this.animating = false;
        if (this.animationThread != null) {
            this.animationThread.interrupt();
            this.animationThread = null;
        }
    }

    public void gotoFrame(int n) {
        if (this.gifDecoder.getCurrentFrameIndex() == n) {
            return;
        }
        if (this.gifDecoder.setFrameIndex(n - 1) && !this.animating) {
            this.renderFrame = true;
            this.startAnimationThread();
        }
    }

    public void resetAnimation() {
        this.gifDecoder.resetLoopIndex();
        this.gotoFrame(0);
    }

    public void clear() {
        this.animating = false;
        this.renderFrame = false;
        this.shouldClear = true;
        this.stopAnimation();
        this.handler.post(this.cleanupRunnable);
    }

    public GifDecoder getDecoder() {
        return this.gifDecoder;
    }

    private boolean canStart() {
        return (this.animating || this.renderFrame) && this.gifDecoder != null && this.animationThread == null;
    }

    public int getGifWidth() {
        return this.gifDecoder.getWidth();
    }

    public int getFrameCount() {
        return this.gifDecoder.getFrameCount();
    }

    public int getGifHeight() {
        return this.gifDecoder.getHeight();
    }

    public void run() {
        if (this.animationStartCallback != null) {
            this.animationStartCallback.onAnimationStart();
        }
        GifDecoder gifDecoder = null;
        do {
            gifDecoder = this.gifDecoder;
            if (!this.animating && !this.renderFrame || gifDecoder == null) break;
            boolean bl = this.gifDecoder.advance();
            long l = 0L;
            try {
                long l2 = System.nanoTime();
                this.tmpBitmap = gifDecoder.getNextFrame();
                if (this.frameCallback != null) {
                    this.tmpBitmap = this.frameCallback.onFrameAvailable(this.tmpBitmap);
                }
                l = (System.nanoTime() - l2) / 1000000L;
                this.handler.post(this.updateResults);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Log.w((String)TAG, (Throwable)arrayIndexOutOfBoundsException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)TAG, (Throwable)illegalArgumentException);
            }
            this.renderFrame = false;
            if (!this.animating || !bl) {
                this.animating = false;
                break;
            }
            try {
                int n = this.gifDecoder.getNextDelay();
                n = (int)((long)n - l);
                if (n <= 0) continue;
                Thread.sleep(this.framesDisplayDuration > 0L ? this.framesDisplayDuration : (long)n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.animating);
        if (this.shouldClear) {
            this.handler.post(this.cleanupRunnable);
        }
        this.animationThread = null;
        if (this.animationStopCallback != null) {
            this.animationStopCallback.onAnimationStop();
        }
    }

    public GifImageView$OnFrameAvailable getOnFrameAvailable() {
        return this.frameCallback;
    }

    public void setOnFrameAvailable(GifImageView$OnFrameAvailable gifImageView$OnFrameAvailable) {
        this.frameCallback = gifImageView$OnFrameAvailable;
    }

    public GifImageView$OnAnimationStop getOnAnimationStop() {
        return this.animationStopCallback;
    }

    public void setOnAnimationStop(GifImageView$OnAnimationStop gifImageView$OnAnimationStop) {
        this.animationStopCallback = gifImageView$OnAnimationStop;
    }

    public void setOnAnimationStart(GifImageView$OnAnimationStart gifImageView$OnAnimationStart) {
        this.animationStartCallback = gifImageView$OnAnimationStart;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clear();
    }

    private void startAnimationThread() {
        if (this.canStart()) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
    }

    static /* synthetic */ Bitmap access$000(GifImageView gifImageView) {
        return gifImageView.tmpBitmap;
    }

    static /* synthetic */ GifImageView$OnFrameChangeListener access$100(GifImageView gifImageView) {
        return gifImageView.mOnFrameChangeListener;
    }

    static /* synthetic */ Bitmap access$002(GifImageView gifImageView, Bitmap bitmap) {
        gifImageView.tmpBitmap = bitmap;
        return gifImageView.tmpBitmap;
    }

    static /* synthetic */ GifDecoder access$202(GifImageView gifImageView, GifDecoder gifDecoder) {
        gifImageView.gifDecoder = gifDecoder;
        return gifImageView.gifDecoder;
    }

    static /* synthetic */ Thread access$302(GifImageView gifImageView, Thread thread) {
        gifImageView.animationThread = thread;
        return gifImageView.animationThread;
    }

    static /* synthetic */ boolean access$402(GifImageView gifImageView, boolean bl) {
        gifImageView.shouldClear = bl;
        return gifImageView.shouldClear;
    }
}

