/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.animatable;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ScrollView;
import oz.util.view.animatable.AnimatableFrameLayout;
import oz.util.view.animatable.AnimatableFrameLayout$OnMoveListener;
import oz.util.view.animatable.AnimatableScrollView$MinHeightRunnable;
import oz.util.view.animatable.AnimatableScrollView$MoveJob;
import oz.util.view.animatable.AnimatableScrollView$OnMoveListener;

public class AnimatableScrollView
extends ScrollView
implements AnimatableFrameLayout$OnMoveListener {
    private AnimatableFrameLayout mView;
    private AnimatableScrollView$OnMoveListener mListener;
    private AnimatableScrollView$MinHeightRunnable mMinHeightRunnable;
    private boolean mScrollToZeroInMove;
    private boolean mScrollBarRemoveInMove;
    private boolean mScrollBarBackup;
    private boolean mTouchDisableInMove;
    private boolean mAutoSetOldView;
    private boolean mUseAutoAlpha;
    private int mCurrentDuration;

    public AnimatableScrollView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mMinHeightRunnable = new AnimatableScrollView$MinHeightRunnable(this, null);
        this.mScrollToZeroInMove = true;
        this.mScrollBarRemoveInMove = true;
        this.mTouchDisableInMove = true;
        this.mAutoSetOldView = true;
        this.mUseAutoAlpha = true;
        this.mView = new AnimatableFrameLayout(this.getContext());
        this.mView.setMoveListener(this);
        this.addView((View)this.mView, new ViewGroup.LayoutParams(-1, -2));
    }

    public AnimatableFrameLayout getContentView() {
        return this.mView;
    }

    private void autoSetOldView(View view) {
        if (this.mAutoSetOldView) {
            this.mView.setOldView(view);
        }
    }

    private void autoSetOldView_Add(View view) {
        if (this.mAutoSetOldView && view != null && this.mView.getChildCount() == 0) {
            this.autoSetOldView(view);
        }
    }

    public void addChildInContentView(View view) {
        this.autoSetOldView_Add(view);
        this.mView.addView(view);
    }

    public void addChildInContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.autoSetOldView_Add(view);
        this.mView.addView(view, layoutParams);
    }

    public void clearOldView() {
        this.mView.setOldView(null);
    }

    public void setMoveListener(AnimatableScrollView$OnMoveListener animatableScrollView$OnMoveListener) {
        this.mListener = animatableScrollView$OnMoveListener;
    }

    public void doMoveNextView(View view, int n, boolean bl) {
        this.doMoveNextView(0L, view, n, bl);
    }

    public void doMoveNextView(long l, View view, int n, boolean bl) {
        AnimatableScrollView$MoveJob animatableScrollView$MoveJob = new AnimatableScrollView$MoveJob(this, null);
        animatableScrollView$MoveJob.nextView = view;
        animatableScrollView$MoveJob.duration = n;
        animatableScrollView$MoveJob.reverse = bl;
        this.postDelayed(animatableScrollView$MoveJob, l);
    }

    public void setTouchDisable(boolean bl) {
        this.mView.setTouchDisable(bl);
    }

    public boolean isTouchDisable() {
        return this.mView.isTouchDisable();
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (this.isTouchDisable()) {
            return true;
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isTouchDisable()) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mMinHeightRunnable.h = n2;
        this.post(this.mMinHeightRunnable);
    }

    public void OnStartMove(AnimatableFrameLayout animatableFrameLayout, View view, View view2, boolean bl) {
        if (this.mTouchDisableInMove) {
            this.mView.setTouchDisable(true);
        }
        if (this.mScrollToZeroInMove) {
            this.smoothScrollTo(0, 0);
        }
        if (this.mScrollBarRemoveInMove) {
            this.mScrollBarBackup = this.isVerticalScrollBarEnabled();
            this.setVerticalScrollBarEnabled(false);
        }
        if (this.mUseAutoAlpha && this.mCurrentDuration > 0) {
            AlphaAnimation alphaAnimation;
            if (view2 != null) {
                alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
                alphaAnimation.setDuration((long)((int)((float)this.mCurrentDuration * 0.2f)));
                alphaAnimation.setFillEnabled(true);
                alphaAnimation.setFillBefore(true);
                alphaAnimation.setFillAfter(true);
                view2.setAnimation((Animation)alphaAnimation);
            }
            if (view != null) {
                alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
                if (bl) {
                    alphaAnimation.setStartOffset((long)((int)((float)this.mCurrentDuration * 0.3f)));
                }
                alphaAnimation.setDuration((long)((int)((float)this.mCurrentDuration * 0.8f)));
                alphaAnimation.setFillEnabled(true);
                alphaAnimation.setFillBefore(true);
                alphaAnimation.setFillAfter(true);
                view.setAnimation((Animation)alphaAnimation);
            }
        }
        if (this.mListener != null) {
            this.mListener.OnStartMove(this, animatableFrameLayout, view, view2, bl);
        }
    }

    public void OnFinishMove(AnimatableFrameLayout animatableFrameLayout, View view, View view2, boolean bl) {
        if (this.mListener != null) {
            this.mListener.OnFinishMove(this, animatableFrameLayout, view, view2, bl);
        }
    }

    public void OnAfterMove(AnimatableFrameLayout animatableFrameLayout, View view, View view2, boolean bl) {
        if (this.mTouchDisableInMove) {
            this.mView.setTouchDisable(false);
        }
        if (this.mScrollBarRemoveInMove) {
            this.setVerticalScrollBarEnabled(this.mScrollBarBackup);
        }
        if (this.mUseAutoAlpha && view != null) {
            view.clearAnimation();
            view.setAlpha(1.0f);
        }
        this.autoSetOldView(view);
        if (this.mListener != null) {
            this.mListener.OnAfterMove(this, animatableFrameLayout, view, view2, bl);
        }
    }

    static /* synthetic */ AnimatableFrameLayout access$000(AnimatableScrollView animatableScrollView) {
        return animatableScrollView.mView;
    }

    static /* synthetic */ int access$102(AnimatableScrollView animatableScrollView, int n) {
        animatableScrollView.mCurrentDuration = n;
        return animatableScrollView.mCurrentDuration;
    }
}

