/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import java.io.IOException;
import oz.main.OZStorage;
import oz.util.drawable.FitBitmapDrawable;
import oz.viewer.ui.df.DFManager;
import oz.viewer.ui.df.DFUtils$1;
import oz.viewer.ui.df.view.DFProgressbar;

public class DFUtils {
    public static final String TAG = DFUtils.class.getSimpleName();
    public static boolean USEC = true;
    public static boolean USED = true;
    private static final int COLOR_VOICE_BTN_BORDER_WIDTH = 1;
    private static final int COLOR_VOICE_BTN_BG = Color.argb((int)25, (int)255, (int)255, (int)255);
    private static final int COLOR_VOICE_BTN_PRESSED = Color.argb((int)128, (int)208, (int)208, (int)208);
    private static final int COLOR_VOICE_BTN_STROKE = Color.argb((int)102, (int)255, (int)255, (int)255);

    public static void c(Context context, String string) {
        if (USEC) {
            Toast toast = Toast.makeText((Context)context, (CharSequence)string, (int)0);
            toast.show();
            Handler handler = new Handler(Looper.getMainLooper());
            handler.postDelayed((Runnable)new DFUtils$1(toast), 500L);
        }
    }

    public static void d(String string) {
        if (USED) {
            Log.d((String)("<###### " + TAG), (String)string);
        }
    }

    public static int toDP(Context context, float f2) {
        return (int)DFUtils.toDP_F(context, f2);
    }

    public static float toDP_F(Context context, float f2) {
        if (f2 == 0.0f) {
            return 0.0f;
        }
        return TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int pxToDp(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        if ((double)f3 == 1.0) {
            f3 = (float)((double)f3 * 4.0);
        } else if ((double)f3 == 1.5) {
            f3 *= 2.0f;
        } else if ((double)f3 == 2.0) {
            f3 = (float)((double)f3 * 2.0);
        }
        return (int)(f2 / f3);
    }

    public static float toSP(Context context, float f2) {
        if (f2 == 0.0f) {
            return 0.0f;
        }
        return TypedValue.applyDimension((int)2, (float)f2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static Drawable getImageDrawable(Context context, int n) {
        Drawable drawable2 = null;
        if (n < DFManager.imageStore.length) {
            try {
                drawable2 = OZStorage.getDrawable(context.getResources().getAssets().open("resource/df/" + DFManager.imageStore[n]));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return drawable2;
    }

    public static Point getScreenSize(Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        Point point = new Point();
        display.getSize(point);
        return point;
    }

    private static void setOnClick(View view, View.OnClickListener onClickListener) {
        if (view != null) {
            view.setOnClickListener(onClickListener);
        }
    }

    public static void setOnClick(Dialog dialog, int n, View.OnClickListener onClickListener) {
        if (dialog != null) {
            DFUtils.setOnClick(dialog.findViewById(n), onClickListener);
        }
    }

    private static void setOnTouch(View view, View.OnTouchListener onTouchListener) {
        if (view != null) {
            view.setOnTouchListener(onTouchListener);
        }
    }

    public static void setOnTouch(Dialog dialog, int n, View.OnTouchListener onTouchListener) {
        if (dialog != null) {
            DFUtils.setOnTouch(dialog.findViewById(n), onTouchListener);
        }
    }

    private static void setProgress(View view, int n, int n2) {
        if (view != null && view instanceof DFProgressbar) {
            DFProgressbar dFProgressbar = (DFProgressbar)view;
            dFProgressbar.setProgressAndMax(n, n2);
        }
    }

    public static void setProgress(Dialog dialog, int n, int n2, int n3) {
        if (dialog != null) {
            DFUtils.setProgress(dialog.findViewById(n), n2, n3);
        }
    }

    public static GradientDrawable getGDNormal() {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(0);
        gradientDrawable.setStroke(1, -1);
        gradientDrawable.setCornerRadius(10.0f);
        return gradientDrawable;
    }

    public static GradientDrawable getGDPressed() {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(Color.argb((int)179, (int)255, (int)255, (int)255));
        gradientDrawable.setStroke(3, -1);
        gradientDrawable.setCornerRadius(10.0f);
        return gradientDrawable;
    }

    public static Button createCustomButton(Context context, int n, String string, GradientDrawable gradientDrawable, View.OnClickListener onClickListener) {
        Button button = new Button(context);
        if (n > 0) {
            button.setId(n);
        }
        if (string != null) {
            button.setText((CharSequence)string);
        }
        button.setBackground((Drawable)gradientDrawable);
        if (onClickListener != null) {
            button.setOnClickListener(onClickListener);
        }
        return button;
    }

    public static void tryCloseEditTextKeyboard(EditText editText) {
        if (editText != null && editText.isFocused()) {
            InputMethodManager inputMethodManager = (InputMethodManager)editText.getContext().getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(editText.getWindowToken(), 0);
        }
    }

    public static BitmapDrawable getBitmapDrawableFromRes(Context context, int n) {
        return (BitmapDrawable)DFUtils.getImageDrawable(context, n);
    }

    public static Drawable createButtonDrawable(Context context, int n, float f2) {
        return DFUtils.createButtonDrawable(context, DFUtils.getBitmapDrawableFromRes(context, n), f2);
    }

    public static Drawable createButtonDrawable(Context context, BitmapDrawable bitmapDrawable, float f2) {
        return new FitBitmapDrawable(bitmapDrawable.getBitmap(), f2);
    }

    public static Drawable createVoiceButtonDrawable(Context context, int n) {
        Drawable drawable2 = DFUtils.createButtonDrawable(context, n, 0.4f);
        Drawable drawable3 = DFUtils.createButtonDrawable(context, n, 0.4f);
        GradientDrawable gradientDrawable = new GradientDrawable();
        GradientDrawable gradientDrawable2 = new GradientDrawable();
        gradientDrawable.setShape(1);
        gradientDrawable.setColor(COLOR_VOICE_BTN_BG);
        gradientDrawable.setStroke(1, COLOR_VOICE_BTN_STROKE);
        gradientDrawable2.setShape(1);
        gradientDrawable2.setColor(COLOR_VOICE_BTN_PRESSED);
        gradientDrawable2.setStroke(1, COLOR_VOICE_BTN_STROKE);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{gradientDrawable2, drawable2});
        LayerDrawable layerDrawable2 = new LayerDrawable(new Drawable[]{gradientDrawable, drawable3});
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842910, 16842919}, (Drawable)layerDrawable);
        stateListDrawable.addState(new int[]{16842910, -16842919}, (Drawable)layerDrawable2);
        return stateListDrawable;
    }

    public static boolean isMobile(Context context) {
        if (context != null) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            Activity activity = (Activity)context;
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            float f2 = (float)displayMetrics.heightPixels / displayMetrics.ydpi;
            float f3 = (float)displayMetrics.widthPixels / displayMetrics.xdpi;
            double d2 = Math.sqrt(f3 * f3 + f2 * f2);
            return !(d2 >= 6.9);
        }
        return false;
    }
}

