/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.File;
import java.io.IOException;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFClearButton;
import oz.viewer.ui.df.view.DFClearButton$Builder;
import oz.viewer.ui.df.view.DFInputCompAttach$DFAttachInterface;
import oz.viewer.ui.df.view.DFInputCompView;
import oz.viewer.ui.df.view.DFSelectItemView;

public class DFInputCompAttach
extends DFInputCompView
implements View.OnClickListener {
    private static final int DP_IMAGE_SIZE = 24;
    private static final int DP_PADDING = 12;
    private static final int SP_TEXT_SIZE = 20;
    private static final int DP_SPACE_16 = 16;
    private DFSelectItemView mBtnPDF;
    private DFSelectItemView mBtnImage;
    private DFSelectItemView mBtnCamera;
    private DFClearButton mResetButton;
    private FrameLayout contentsView;
    private LinearLayout attachButtonsLayout;
    private LinearLayout attachCompleteLayout;

    public DFInputCompAttach(Context context, DFInputCompAttach$DFAttachInterface dFInputCompAttach$DFAttachInterface) {
        super(context, dFInputCompAttach$DFAttachInterface);
    }

    private DFInputCompAttach$DFAttachInterface getInterface() {
        return (DFInputCompAttach$DFAttachInterface)this.getDFInterface();
    }

    protected void create(int n, int n2) {
        this.getInterface().setStopNextSpeech(true);
        int n3 = DFUtils.toDP(this.getContext(), 5.0f);
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setPadding(0, n3, 0, n3);
        this.contentsView = new FrameLayout(this.getContext());
        this.attachButtonsLayout = new LinearLayout(this.getContext());
        this.attachButtonsLayout.setOrientation(1);
        this.attachButtonsLayout.setPadding(0, n3, 0, n3);
        this.attachCompleteLayout = new LinearLayout(this.getContext());
        this.attachCompleteLayout.setOrientation(0);
        this.attachCompleteLayout.setPadding(0, n3, 0, n3);
        int n4 = DFUtils.toDP(this.getContext(), 24.0f);
        this.mBtnPDF = new DFSelectItemView(this.getContext(), DFUtils.getImageDrawable(this.getContext(), 18));
        this.mBtnPDF.setImageViewSize(n4);
        this.mBtnPDF.setText(this.getInterface().getBtnPDFResource());
        this.mBtnPDF.setOnClickListener(this);
        this.mBtnPDF.setOnTouchListener(this.DFOnTouchListener);
        this.mBtnCamera = new DFSelectItemView(this.getContext(), DFUtils.getImageDrawable(this.getContext(), 19));
        this.mBtnCamera.setImageViewSize(n4);
        this.mBtnCamera.setText(this.getInterface().getBtnCameraResource());
        this.mBtnCamera.setOnClickListener(this);
        this.mBtnCamera.setOnTouchListener(this.DFOnTouchListener);
        this.mBtnImage = new DFSelectItemView(this.getContext(), DFUtils.getImageDrawable(this.getContext(), 20));
        this.mBtnImage.setImageViewSize(n4);
        this.mBtnImage.setText(this.getInterface().getBtnGalleryResource());
        this.mBtnImage.setOnClickListener(this);
        this.mBtnImage.setOnTouchListener(this.DFOnTouchListener);
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(0);
        gradientDrawable.setStroke(3, -1);
        gradientDrawable.setColor(0);
        gradientDrawable.setCornerRadius(100.0f);
        int n5 = DFUtils.toDP(this.getContext(), 12.0f);
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)this.getInterface().getTextAfterInput());
        textView.setTextSize(20.0f);
        textView.setTextColor(-1);
        textView.setBackground((Drawable)gradientDrawable);
        textView.setPadding(n5, n5, n5, n5);
        this.mResetButton = new DFClearButton$Builder((ViewGroup)this.attachCompleteLayout).setOnClickListener(this).setSizeDP(31).setLayoutMarginLeftDP(16).create();
        this.attachButtonsLayout.addView((View)this.mBtnPDF);
        this.attachButtonsLayout.addView((View)this.mBtnCamera);
        this.attachButtonsLayout.addView((View)this.mBtnImage);
        this.attachCompleteLayout.addView((View)textView);
        this.attachCompleteLayout.addView((View)this.mResetButton);
        this.attachCompleteLayout.setGravity(19);
        this.contentsView.addView((View)this.attachButtonsLayout);
        this.contentsView.addView((View)this.attachCompleteLayout);
        linearLayout.addView((View)this.contentsView);
        linearLayout.addView(this.createConfirmBtn((ViewGroup)linearLayout));
        this.addView((View)linearLayout);
    }

    protected void updateSizeChanged(int n, int n2) {
        int n3 = 0;
        DFSelectItemView[] dFSelectItemViewArray = new DFSelectItemView[]{this.mBtnPDF, this.mBtnCamera, this.mBtnImage};
        for (int j = 0; j < dFSelectItemViewArray.length; ++j) {
            dFSelectItemViewArray[j].measure(0, 0);
            int n4 = dFSelectItemViewArray[j].getMeasuredWidth();
            n3 = Math.max(n4, n3);
        }
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(n3, -2);
        layoutParams.topMargin = DFUtils.toDP(this.getContext(), 10.0f);
        this.mBtnPDF.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mBtnCamera.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mBtnImage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.getValue() != null && !this.getValue().toString().isEmpty()) {
            this.updateView(true);
        } else {
            this.updateView(false);
        }
    }

    protected void updateInternal(boolean bl) {
    }

    private void chooseFile() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        intent = Intent.createChooser((Intent)intent, (CharSequence)"Choose a file");
        ((Activity)this.getContext()).startActivityForResult(intent, 13201);
    }

    private void imageCapture() {
        File file;
        File file2 = this.getContext().getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if ((file = new File(file2, "OZ_TMP_IMAGE")).exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            file = null;
            iOException.printStackTrace();
        }
        if (file != null) {
            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)file));
            ((Activity)this.getContext()).startActivityForResult(intent, 13202);
        } else {
            Log.e((String)"OZViewer", (String)"invalid path");
        }
    }

    public void showGallery() {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("image/*");
        ((Activity)this.getContext()).startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Select picture"), 13203);
    }

    private void selectView(View view) {
        this.mBtnPDF.setSelected(false);
        this.mBtnCamera.setSelected(false);
        this.mBtnImage.setSelected(false);
        view.setSelected(true);
    }

    public void onClick(View view) {
        if (view != null) {
            if (view instanceof DFSelectItemView) {
                if (view == this.mBtnPDF) {
                    this.chooseFile();
                } else if (view == this.mBtnCamera) {
                    this.imageCapture();
                } else if (view == this.mBtnImage) {
                    this.showGallery();
                }
                this.selectView(view);
            } else if (view instanceof DFClearButton && view == this.mResetButton) {
                this.setValue(null);
                this.updateView(false);
            }
        }
    }

    public void completeAttach() {
        if (this.getValue() != null && !this.getValue().toString().isEmpty()) {
            this.updateView(true);
        }
    }

    private void updateView(boolean bl) {
        if (bl) {
            this.attachButtonsLayout.setVisibility(4);
            this.attachCompleteLayout.setVisibility(0);
        } else {
            this.attachButtonsLayout.setVisibility(0);
            this.attachCompleteLayout.setVisibility(4);
        }
    }
}

