/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFCheckView;
import oz.viewer.ui.df.view.DFClearButton$Builder;
import oz.viewer.ui.df.view.DFInputCompTextBox$1;
import oz.viewer.ui.df.view.DFInputCompTextBox$2;
import oz.viewer.ui.df.view.DFInputCompTextBox$DFTextBoxInterface;
import oz.viewer.ui.df.view.DFInputCompView;

public class DFInputCompTextBox
extends DFInputCompView
implements TextWatcher,
View.OnClickListener {
    private static final int DP_RECT_WIDTH = 2;
    private boolean mTextWatcher;
    private EditText mEditText;
    private Button mResetButton;
    private int mCursor;
    DFCheckView checkView;
    private boolean mIsMultiline;
    private int mReturnType;
    private int m_maxLength;
    private InputFilter dot_move_filter = null;

    public DFInputCompTextBox(Context context, DFInputCompTextBox$DFTextBoxInterface dFInputCompTextBox$DFTextBoxInterface) {
        super(context, dFInputCompTextBox$DFTextBoxInterface);
        this.setFocusable(true);
        this.mTextWatcher = false;
        this.mCursor = -1;
    }

    private DFInputCompTextBox$DFTextBoxInterface getInterface() {
        return (DFInputCompTextBox$DFTextBoxInterface)this.getDFInterface();
    }

    protected void create(int n, int n2) {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setOrientation(0);
        linearLayout2.setGravity(16);
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        this.mEditText = new EditText(this.getContext());
        this.mEditText.setTextColor(-1);
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(0);
        gradientDrawable.setStroke(DFUtils.toDP(this.getContext(), 2.0f), -1);
        gradientDrawable.setColor(0);
        this.mEditText.setBackground((Drawable)gradientDrawable);
        DFInputCompTextBox.setCursorDrawableColor(this.mEditText, -1);
        this.mEditText.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.mEditText.setMinimumHeight(100);
        this.mIsMultiline = this.getInterface().getMultiLine();
        if (this.mIsMultiline) {
            this.mEditText.setMaxLines(3);
        }
        this.mReturnType = 0 != this.getInterface().getReturnKeyType() ? this.getInterface().getReturnKeyType() : 0;
        this.updateReturnKeyType();
        this.m_maxLength = this.getInterface().getMaxLength();
        if (this.getInterface().getKeyBoardType() == 4) {
            this.mEditText.setInputType(33);
        } else if (this.getInterface().getKeyBoardType() == 2) {
            this.mEditText.setInputType(12418);
        } else if (!this.mIsMultiline) {
            this.mEditText.setInputType(1);
        }
        this.mEditText.addTextChangedListener((TextWatcher)this);
        this.mEditText.setBackgroundTintList(ColorStateList.valueOf((int)-1));
        int n3 = this.mEditText.getPaddingLeft();
        int n4 = this.mEditText.getPaddingTop();
        int n5 = DFUtils.toDP(this.getContext(), 32.0f);
        int n6 = this.mEditText.getPaddingBottom();
        this.mEditText.setPadding(n3, n4 * 2, n5, n6 * 2);
        this.mEditText.setOnFocusChangeListener((View.OnFocusChangeListener)new DFInputCompTextBox$1(this));
        this.mResetButton = new DFClearButton$Builder((ViewGroup)frameLayout).setOnClickListener(this).setSizeDP(22).setLayoutMarginRightDP(10).setLayoutGravity(21).create();
        this.mResetButton.setVisibility(0);
        this.checkView = new DFCheckView(this.getContext());
        linearLayout2.addView((View)this.checkView);
        frameLayout.addView((View)this.mEditText);
        frameLayout.addView((View)this.mResetButton);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        linearLayout2.addView((View)frameLayout);
        linearLayout.addView((View)linearLayout2);
        linearLayout.addView(this.createConfirmBtn((ViewGroup)linearLayout));
        this.addView((View)linearLayout);
    }

    boolean isNormalType() {
        return this.getInterface().getTextInputMode() == 1;
    }

    private int getReturnKeyType() {
        return this.mIsMultiline ? 0 : this.mReturnType;
    }

    boolean isNumericKeyboard() {
        return this.isNormalType() && this.getInterface().getKeyBoardType() == 2;
    }

    private boolean hasFilter() {
        return this.m_maxLength > 0 || this.isNumericKeyboard();
    }

    public void setFilters(EditText editText) {
        if (this.hasFilter()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.m_maxLength > 0) {
                if (editText.length() <= this.m_maxLength) {
                    arrayList.add(new InputFilter.LengthFilter(this.m_maxLength));
                } else {
                    arrayList.add(new InputFilter.LengthFilter(editText.length()));
                }
            }
            if (this.isNumericKeyboard()) {
                if (this.dot_move_filter == null) {
                    this.dot_move_filter = new DFInputCompTextBox$2(this, editText);
                }
                arrayList.add(this.dot_move_filter);
            }
            if (arrayList != null) {
                InputFilter[] inputFilterArray = new InputFilter[arrayList.size()];
                arrayList.toArray(inputFilterArray);
                editText.setFilters(inputFilterArray);
            }
        }
    }

    private void updateReturnKeyType() {
        int n = Build.VERSION.SDK_INT > 10 ? 0x2000000 : 0x10000000;
        switch (this.getReturnKeyType()) {
            case 4: {
                n |= 5;
                break;
            }
            case 2: {
                n |= 2;
                break;
            }
            case 5: {
                n |= 3;
                break;
            }
            case 6: {
                n |= 4;
                break;
            }
            default: {
                n |= 6;
            }
        }
        this.mEditText.setImeOptions(n);
    }

    protected void updateSizeChanged(int n, int n2) {
    }

    protected void updateInternal(boolean bl) {
        if (this.isValueChanged()) {
            if (bl) {
                this.checkView.requestPlay();
            }
            this.editTextUpdate(bl);
            this.mCursor = -1;
            this.clearValueChanged();
        }
    }

    private void editTextUpdate(boolean bl) {
        if (this.mEditText != null && (bl || !this.mTextWatcher)) {
            this.mEditText.setText((CharSequence)(this.getValue() != null ? this.getValue().toString() : ""));
            if (this.mCursor >= 0) {
                this.mEditText.setSelection(this.mCursor);
            } else {
                this.mEditText.setSelection(this.mEditText.getText().length());
            }
        }
    }

    protected void disposeInternal(boolean bl) {
        super.disposeInternal(bl);
        DFUtils.tryCloseEditTextKeyboard(this.mEditText);
        this.mEditText.clearFocus();
    }

    protected boolean equalValue(Object object) {
        boolean bl = super.equalValue(object);
        if (!bl && object != null) {
            bl = object.equals(this.getValue());
        }
        return bl;
    }

    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        this.setFilters(this.mEditText);
    }

    public void afterTextChanged(Editable editable) {
        if (!this.mTextWatcher) {
            this.mTextWatcher = true;
            String string = editable.toString();
            if (this.getInterface().hasTextFilter()) {
                String string2 = this.getInterface().getFilteringText(editable.toString(), this.mEditText.getSelectionStart());
                if (string2.isEmpty()) {
                    string2 = editable.toString();
                }
                this.mEditText.setText((CharSequence)string2);
                int n = this.getInterface().getCaret();
                this.mEditText.setSelection(n);
                string = string2;
            }
            this.setValue(string, true);
            this.editTextUpdate(false);
            this.mTextWatcher = false;
        }
        if (editable.toString().equals("")) {
            this.mResetButton.setVisibility(4);
        } else {
            this.mResetButton.setVisibility(0);
        }
    }

    public void onClick(View view) {
        if (view == this.mResetButton) {
            this.mEditText.setText((CharSequence)"");
        }
    }

    public static void setCursorDrawableColor(EditText editText, int n) {
        if (Build.VERSION.SDK_INT >= 29) {
            ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new RectShape());
            shapeDrawable.setIntrinsicWidth(2);
            shapeDrawable.getPaint().setColor(n);
            try {
                Method method = editText.getClass().getMethod("setTextCursorDrawable", Drawable.class);
                method.invoke((Object)editText, shapeDrawable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                Field field = TextView.class.getDeclaredField("mCursorDrawableRes");
                field.setAccessible(true);
                int n2 = field.getInt(editText);
                Field field2 = TextView.class.getDeclaredField("mEditor");
                field2.setAccessible(true);
                Object object = field2.get(editText);
                Class<?> clazz = object.getClass();
                Resources resources = editText.getContext().getResources();
                if (Build.VERSION.SDK_INT >= 28) {
                    Field field3 = clazz.getDeclaredField("mDrawableForCursor");
                    field3.setAccessible(true);
                    Drawable drawable2 = resources.getDrawable(n2);
                    drawable2.setColorFilter(n, PorterDuff.Mode.SRC_IN);
                    field3.set(object, drawable2);
                } else {
                    Field field4 = clazz.getDeclaredField("mCursorDrawable");
                    field4.setAccessible(true);
                    Drawable[] drawableArray = new Drawable[]{resources.getDrawable(n2), resources.getDrawable(n2)};
                    drawableArray[0].setColorFilter(n, PorterDuff.Mode.SRC_IN);
                    drawableArray[1].setColorFilter(n, PorterDuff.Mode.SRC_IN);
                    field4.set(object, drawableArray);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    static /* synthetic */ DFInputCompTextBox$DFTextBoxInterface access$000(DFInputCompTextBox dFInputCompTextBox) {
        return dFInputCompTextBox.getInterface();
    }
}

