/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFLayoutHelper$PROGRESSBAR_POSITION;

public class DFProgressbar
extends LinearLayout
implements Runnable {
    private static final int DP_PADDING = 6;
    private static final int DP_PADDING_LR = 19;
    private static final int DP_PROGRESS_RAD = 5;
    private static final int DP_PROGRESS_HEIGHT = 4;
    private static final int COLOR_PROGRESS = Color.rgb((int)13, (int)129, (int)255);
    private static final int COLOR_PROGRESS_BG = Color.argb((int)76, (int)255, (int)255, (int)255);
    private static final float COLOR_ALPHA_TEXT = 0.8f;
    private static final int COLOR_TEXT = -1;
    private static final String TEXT_FORMAT = "%d / %d %s";
    private static final float SP_TEXT = 14.0f;
    private String TEXT_COMPLETE = "\uc9c4\ud589\uc911";
    private TextView mTextView;
    private ProgressBar mProgressbar;
    private String mLocale;
    private DFLayoutHelper$PROGRESSBAR_POSITION mPosition;

    public DFProgressbar(Context context, String string, DFLayoutHelper$PROGRESSBAR_POSITION dFLayoutHelper$PROGRESSBAR_POSITION) {
        super(context);
        this.mLocale = string;
        this.mPosition = dFLayoutHelper$PROGRESSBAR_POSITION;
        this.init();
    }

    private void init() {
        this.TEXT_COMPLETE = this.mLocale.equalsIgnoreCase("en-US") ? "" : "\uc9c4\ud589\uc911";
        this.setGravity(21);
        this.setOrientation(1);
        int n = DFUtils.toDP(this.getContext(), 19.0f);
        this.setPadding(n, 0, n, 0);
        this.initProgessbar();
    }

    private void initProgessbar() {
        Context context = this.getContext();
        this.mProgressbar = new ProgressBar(context, null, 16973855);
        this.mProgressbar.setProgressDrawable(this.createProgressDrawable());
        this.mProgressbar.setIndeterminate(false);
        this.addView((View)this.mProgressbar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, DFUtils.toDP(context, 4.0f)));
    }

    private Drawable createProgressDrawable() {
        Drawable drawable2 = this.createShapeDrawable(false);
        ScaleDrawable scaleDrawable = new ScaleDrawable(this.createShapeDrawable(true), 3, 1.0f, -1.0f);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{drawable2, scaleDrawable, scaleDrawable});
        layerDrawable.setId(0, 0x1020000);
        layerDrawable.setId(1, 16908303);
        layerDrawable.setId(2, 16908301);
        return layerDrawable;
    }

    private Drawable createShapeDrawable(boolean bl) {
        ShapeDrawable shapeDrawable;
        if (this.mPosition == DFLayoutHelper$PROGRESSBAR_POSITION.TOP) {
            shapeDrawable = new ShapeDrawable();
        } else {
            float f2 = DFUtils.toDP_F(this.getContext(), 5.0f);
            RoundRectShape roundRectShape = new RoundRectShape(new float[]{f2, f2, f2, f2, f2, f2, f2, f2}, null, null);
            shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        }
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable.getPaint().setColor(bl ? COLOR_PROGRESS : COLOR_PROGRESS_BG);
        return shapeDrawable;
    }

    private boolean setProgressInternal(int n) {
        if (this.mProgressbar.getProgress() != n) {
            this.mProgressbar.setProgress(n);
            return true;
        }
        return false;
    }

    public void setProgress(int n) {
        if (this.setProgressInternal(n)) {
            // empty if block
        }
    }

    private boolean setMaxInternal(int n) {
        if (this.mProgressbar.getMax() != n) {
            this.mProgressbar.setMax(n);
            return true;
        }
        return false;
    }

    public void setMax(int n) {
        if (this.setMaxInternal(n)) {
            // empty if block
        }
    }

    public void setProgressAndMax(int n, int n2) {
        boolean bl = false;
        if (this.setProgressInternal(n)) {
            bl = true;
        }
        if (this.setMaxInternal(n2)) {
            bl = true;
        }
    }

    public void run() {
    }
}

