/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.os.Build;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.json.JSONObject;
import oz.viewer.ui.edit.ACanvasCommentView$DrawSurfaceView;
import oz.viewer.ui.edit.ACanvasCommentView$DrawThread;
import oz.viewer.ui.edit.ACanvasCommentView$OZCommentPath;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableFrameLayout;

public class ACanvasCommentView
extends AEditableFrameLayout {
    private static final float TOUCH_TOLERANCE = 4.0f;
    private float mX;
    private float mY;
    public ArrayList m_commentPathLists = new ArrayList();
    public ArrayList m_commentPathTmpLists = new ArrayList();
    public ACanvasCommentView$OZCommentPath m_commentPath;
    private Paint m_paint;
    private Path m_path = new Path();
    private Paint m_paint_draw;
    private Path m_path_draw;
    private Bitmap mBitmap;
    private Object mDrawLock;
    private Object mBitmapLock;
    private ACanvasCommentView$DrawThread mThread;
    private ACanvasCommentView$DrawSurfaceView mSurface;
    private boolean m_isZoomMode;
    long m_time;

    public ACanvasCommentView(Context context, AEditableBaseView aEditableBaseView) {
        super(context, aEditableBaseView);
        this.m_paint = new Paint();
        this.setPaint(this.m_paint);
        this.m_path_draw = new Path();
        this.m_paint_draw = new Paint();
        this.setPaint(this.m_paint_draw);
        this.mDrawLock = new Object();
        this.mBitmapLock = new Object();
        try {
            if (Build.VERSION.SDK_INT >= 11) {
                Method method = this.getClass().getMethod("setLayerType", Integer.TYPE, Paint.class);
                method.invoke((Object)this, 1, null);
            }
        }
        catch (Exception exception) {
            Log.d((String)"OZViewer", (String)"Not supported layout type.");
        }
        AEditableBaseView.m_selectedObject = null;
        this.mSurface = new ACanvasCommentView$DrawSurfaceView(this, this.getContext());
        this.mSurface.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView(this.mSurface);
    }

    private void setPaint(Paint paint) {
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setAntiAlias(true);
        paint.setDither(true);
    }

    public void createCommentPath(JSONObject jSONObject) {
        this.m_commentPathLists.add(new ACanvasCommentView$OZCommentPath(this, jSONObject));
    }

    public FrameLayout getCommentView() {
        return this;
    }

    protected void onDraw(Canvas canvas) {
    }

    private void drawPath(Canvas canvas, ACanvasCommentView$OZCommentPath aCanvasCommentView$OZCommentPath, Path path, Paint paint) {
        if (canvas != null && aCanvasCommentView$OZCommentPath != null && aCanvasCommentView$OZCommentPath.getSize() >= 2) {
            paint.setStrokeWidth(aCanvasCommentView$OZCommentPath.m_scaledStrokeSize / this.getBaseView().m_canvasW);
            paint.setColor(aCanvasCommentView$OZCommentPath.getColor());
            paint.setAlpha(aCanvasCommentView$OZCommentPath.getMode() == 0 ? 255 : 80);
            path.reset();
            PointF pointF = aCanvasCommentView$OZCommentPath.getAt(0);
            PointF pointF2 = null;
            path.moveTo(pointF.x / this.getBaseView().m_canvasW + this.getBaseView().getDstRect().left, pointF.y / this.getBaseView().m_canvasW + this.getBaseView().getDstRect().top);
            for (int j = 1; j < aCanvasCommentView$OZCommentPath.getSize(); ++j) {
                pointF = aCanvasCommentView$OZCommentPath.getAt(j - 1);
                pointF2 = aCanvasCommentView$OZCommentPath.getAt(j);
                path.quadTo(pointF.x / this.getBaseView().m_canvasW + this.getBaseView().getDstRect().left, pointF.y / this.getBaseView().m_canvasW + this.getBaseView().getDstRect().top, (pointF.x / this.getBaseView().m_canvasW + pointF2.x / this.getBaseView().m_canvasW) / 2.0f + this.getBaseView().getDstRect().left, (pointF.y / this.getBaseView().m_canvasW + pointF2.y / this.getBaseView().m_canvasW) / 2.0f + this.getBaseView().getDstRect().top);
            }
            if (this.m_commentPath != aCanvasCommentView$OZCommentPath) {
                path.lineTo(pointF2.x / this.getBaseView().m_canvasW + this.getBaseView().getDstRect().left, pointF2.y / this.getBaseView().m_canvasW + this.getBaseView().getDstRect().top);
            }
            canvas.save();
            canvas.clipRect(this.getBaseView().getDstRect());
            canvas.drawPath(path, paint);
            canvas.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getPointerCount();
        if (n > 1) {
            this.m_isZoomMode = true;
            this.getBaseView().m_imageEditor_middle_Layout.onTouchEvent(motionEvent);
            return false;
        }
        float f2 = motionEvent.getX();
        float f3 = motionEvent.getY();
        Point point = this.getBaseView().m_imageEditor_middle_Layout.getScaledTouch(f2, f3);
        f2 = point.x;
        f3 = point.y;
        switch (motionEvent.getAction()) {
            case 0: {
                if (this.m_isZoomMode) break;
                this.m_commentPath = new ACanvasCommentView$OZCommentPath(this, (f2 - this.getBaseView().getDstRect().left) * this.getBaseView().m_canvasW, (f3 - this.getBaseView().getDstRect().top) * this.getBaseView().m_canvasW);
                if (!this.getBaseView().isCommentEraser()) {
                    this.m_commentPath.setColor(this.getBaseView().getPenColor(this.getBaseView().getCommentMode()));
                    this.m_commentPath.m_scaledStrokeSize = (float)(this.getBaseView().getPenThick(this.getBaseView().getCommentMode()) + 1) * this.getBaseView().m_canvasW;
                    this.m_commentPath.setStroke(this.m_commentPath.m_scaledStrokeSize);
                }
                this.m_commentPath.setMode(this.getBaseView().getCommentMode());
                this.mX = f2;
                this.mY = f3;
                this.invalidate();
                break;
            }
            case 2: {
                if (this.m_isZoomMode) break;
                float f4 = Math.abs(f2 - this.mX);
                float f5 = Math.abs(f3 - this.mY);
                if (!(f4 >= 4.0f) && !(f5 >= 4.0f)) break;
                this.mX = f2;
                this.mY = f3;
                if (this.m_commentPath == null && this.getBaseView().getCommentMode() != 2) {
                    this.m_commentPath = new ACanvasCommentView$OZCommentPath(this, f2 - this.getBaseView().getDstRect().left, f3 - this.getBaseView().getDstRect().top);
                    this.m_commentPath.setColor(this.getBaseView().getPenColor(this.getBaseView().getCommentMode()));
                    this.m_commentPath.setStroke(this.getBaseView().getPenThick(this.getBaseView().getCommentMode()));
                    this.m_commentPath.setMode(this.getBaseView().getCommentMode());
                }
                if (this.getBaseView().getCommentMode() != 2) {
                    this.getBaseView().setDirty();
                    this.m_commentPath.add((f2 - this.getBaseView().getDstRect().left) * this.getBaseView().m_canvasW, (f3 - this.getBaseView().getDstRect().top) * this.getBaseView().m_canvasW);
                    this.invalidate();
                    break;
                }
                if (this.m_commentPath == null) break;
                boolean bl = false;
                for (int j = 0; j < this.m_commentPathLists.size(); ++j) {
                    PointF pointF;
                    PointF pointF2;
                    ACanvasCommentView$OZCommentPath aCanvasCommentView$OZCommentPath = (ACanvasCommentView$OZCommentPath)this.m_commentPathLists.get(j);
                    boolean bl2 = aCanvasCommentView$OZCommentPath.isIntersect(pointF2 = this.m_commentPath.getAt(0), pointF = new PointF((f2 - this.getBaseView().getDstRect().left) * this.getBaseView().m_canvasW, (f3 - this.getBaseView().getDstRect().top) * this.getBaseView().m_canvasW));
                    if (!bl2) continue;
                    bl = true;
                    this.getBaseView().setDirty();
                    this.m_commentPathLists.remove(j);
                }
                if (!bl) break;
                this.initDrawThread();
                this.startDrawThread();
                break;
            }
            case 1: 
            case 3: {
                if (!this.m_isZoomMode) {
                    if (this.getBaseView().getCommentMode() != 2 && this.m_commentPath != null) {
                        ACanvasCommentView$OZCommentPath aCanvasCommentView$OZCommentPath = this.m_commentPath;
                        this.m_commentPath = null;
                        this.initDrawThread();
                        this.m_commentPathLists.add(aCanvasCommentView$OZCommentPath);
                        this.mThread.setNew(aCanvasCommentView$OZCommentPath);
                        ArrayList arrayList = this.m_commentPathTmpLists;
                        synchronized (arrayList) {
                            this.m_commentPathTmpLists.add(aCanvasCommentView$OZCommentPath);
                        }
                        this.startDrawThread();
                        this.mSurface.resetPathCount();
                    } else {
                        this.m_commentPath = null;
                    }
                }
                this.m_isZoomMode = false;
            }
        }
        return this.getBaseView().getMode() == 10001;
    }

    private void calcPath() {
        for (int j = 0; j < this.m_commentPathLists.size(); ++j) {
            ACanvasCommentView$OZCommentPath aCanvasCommentView$OZCommentPath = (ACanvasCommentView$OZCommentPath)this.m_commentPathLists.get(j);
            if (!aCanvasCommentView$OZCommentPath.isFromJson()) continue;
            for (int k = 0; k < aCanvasCommentView$OZCommentPath.commentPoint.size(); ++k) {
                PointF pointF = (PointF)aCanvasCommentView$OZCommentPath.commentPoint.get(k);
                pointF.set(pointF.x, pointF.y);
            }
        }
    }

    public void initDrawThread() {
        if (this.mThread != null) {
            this.mThread.cancel();
        }
        this.mThread = new ACanvasCommentView$DrawThread(this);
    }

    public void startDrawThread() {
        this.mThread.start();
    }

    public void updateSurface() {
        this.mSurface.update();
    }

    public void BitmapPostInvalidate() {
        this.mSurface.postInvalidate();
        this.updateSurface();
    }

    public void BitmapInvalidate() {
        this.mSurface.invalidate();
        this.updateSurface();
    }

    public void invalidate() {
        this.mSurface.invalidate();
        this.updateSurface();
    }

    public void postInvalidate() {
        this.mSurface.postInvalidate();
        this.updateSurface();
    }

    static /* synthetic */ Object access$000(ACanvasCommentView aCanvasCommentView) {
        return aCanvasCommentView.mDrawLock;
    }

    static /* synthetic */ void access$100(ACanvasCommentView aCanvasCommentView) {
        aCanvasCommentView.calcPath();
    }

    static /* synthetic */ Bitmap access$200(ACanvasCommentView aCanvasCommentView) {
        return aCanvasCommentView.mBitmap;
    }

    static /* synthetic */ Path access$300(ACanvasCommentView aCanvasCommentView) {
        return aCanvasCommentView.m_path_draw;
    }

    static /* synthetic */ Paint access$400(ACanvasCommentView aCanvasCommentView) {
        return aCanvasCommentView.m_paint_draw;
    }

    static /* synthetic */ void access$500(ACanvasCommentView aCanvasCommentView, Canvas canvas, ACanvasCommentView$OZCommentPath aCanvasCommentView$OZCommentPath, Path path, Paint paint) {
        aCanvasCommentView.drawPath(canvas, aCanvasCommentView$OZCommentPath, path, paint);
    }

    static /* synthetic */ Object access$600(ACanvasCommentView aCanvasCommentView) {
        return aCanvasCommentView.mBitmapLock;
    }

    static /* synthetic */ Bitmap access$202(ACanvasCommentView aCanvasCommentView, Bitmap bitmap) {
        aCanvasCommentView.mBitmap = bitmap;
        return aCanvasCommentView.mBitmap;
    }

    static /* synthetic */ Path access$700(ACanvasCommentView aCanvasCommentView) {
        return aCanvasCommentView.m_path;
    }

    static /* synthetic */ Paint access$800(ACanvasCommentView aCanvasCommentView) {
        return aCanvasCommentView.m_paint;
    }
}

