/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.IOException;
import java.io.InputStream;
import oz.main.OZStorage;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableBorderLinearLayout;
import oz.viewer.ui.edit.AEditableBorderLinearLayout$OnFirstDrawListener;
import oz.viewer.ui.edit.AEditableConst$Size;
import oz.viewer.ui.edit.AEditableImageButton;
import oz.viewer.ui.edit.APopupColorButton;
import oz.viewer.ui.edit.APopupImageButton;

public class AEditableUtil {
    static void constInit() {
        if (AEditableConst$Size.EDITABLE_GAP_1 == 0.0f) {
            AEditableConst$Size.EDITABLE_GAP_1 = OZStorage.getDensityDPI();
            AEditableConst$Size.EDITABLE_GAP_5 = OZStorage.padding_5;
            AEditableConst$Size.EDITABLE_GAP_2_5 = OZStorage.getDensityDPI() * 2.5f;
            AEditableConst$Size.EDITABLE_GAP_6 = OZStorage.getDensityDPI() * 6.0f;
            AEditableConst$Size.EDITABLE_GAP_10 = OZStorage.padding_10;
            AEditableConst$Size.EDITABLE_GAP_15 = (int)(OZStorage.getDensityDPI() * 15.0f);
            AEditableConst$Size.EDITABLE_GAP_20 = OZStorage.padding_20;
            AEditableConst$Size.EDITABLE_GAP_25 = (int)(OZStorage.getDensityDPI() * 25.0f);
            AEditableConst$Size.EDITABLE_GAP_30 = (int)(OZStorage.getDensityDPI() * 30.0f);
            AEditableConst$Size.EDITABLE_GAP_80 = (int)(OZStorage.getDensityDPI() * 80.0f);
            AEditableConst$Size.EDITABLE_GAP_100 = (int)(OZStorage.getDensityDPI() * 100.0f);
        }
    }

    static void setViewPadding(View view, float f2) {
        AEditableUtil.setViewPadding(view, (int)f2);
    }

    static void setViewPadding(View view, int n) {
        AEditableUtil.setViewPadding(view, n, n, n, n);
    }

    static void setViewPadding(View view, int n, int n2) {
        AEditableUtil.setViewPadding(view, n, n2, n, n2);
    }

    static void setViewPadding(View view, int n, int n2, int n3, int n4) {
        if (view != null) {
            view.setPadding(n, n2, n3, n4);
        }
    }

    static AEditableBorderLinearLayout createBorderLayout(Context context, AEditableBorderLinearLayout$OnFirstDrawListener aEditableBorderLinearLayout$OnFirstDrawListener) {
        AEditableBorderLinearLayout aEditableBorderLinearLayout = new AEditableBorderLinearLayout(context, aEditableBorderLinearLayout$OnFirstDrawListener);
        aEditableBorderLinearLayout.setBackgroundColor(0);
        return aEditableBorderLinearLayout;
    }

    static AEditableImageButton createImageButton(Context context, String string, int n, View.OnClickListener onClickListener) {
        AEditableImageButton aEditableImageButton = new AEditableImageButton(context, string, -2);
        if (n > 0) {
            aEditableImageButton.setId(n);
        }
        if (onClickListener != null) {
            aEditableImageButton.setOnClickListener(onClickListener);
        }
        return aEditableImageButton;
    }

    static APopupImageButton createPopupImagebutton(Context context, AEditableBaseView aEditableBaseView, int n) {
        APopupImageButton aPopupImageButton = n == 5 ? new APopupImageButton(context) : new APopupImageButton(context, n, -2, aEditableBaseView);
        return aPopupImageButton;
    }

    static View createPopupImageButtonDummy(Context context) {
        return AEditableUtil.createPopupImageButtonDummy(context, -16777216);
    }

    static View createPopupImageButtonDummy(Context context, int n) {
        TextView textView = new TextView(context);
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams((int)AEditableConst$Size.EDITABLE_GAP_1, -1));
        textView.setBackgroundColor(n);
        return textView;
    }

    static View createPopupVerticalDummy(Context context) {
        TextView textView = new TextView(context);
        textView.setHeight(AEditableConst$Size.EDITABLE_GAP_20);
        return textView;
    }

    static View createPopupVerticalHalfDummy(Context context) {
        TextView textView = new TextView(context);
        textView.setHeight(AEditableConst$Size.EDITABLE_GAP_10);
        return textView;
    }

    static View createPopupColorDummy(Context context) {
        TextView textView = new TextView(context);
        textView.setWidth(AEditableConst$Size.EDITABLE_GAP_10);
        return textView;
    }

    private static LinearLayout createColorLayout(APopupColorButton aPopupColorButton) {
        LinearLayout linearLayout = new LinearLayout(aPopupColorButton.getContext());
        AEditableUtil.setViewPadding((View)linearLayout, AEditableConst$Size.EDITABLE_GAP_5);
        linearLayout.addView((View)aPopupColorButton);
        return linearLayout;
    }

    static LinearLayout createColorLayout(Context context, AEditableBaseView aEditableBaseView, int n, int n2, int n3) {
        return AEditableUtil.createColorLayout(new APopupColorButton(context, n, n2, n3, aEditableBaseView));
    }

    static LinearLayout createCustomColorLayout(Context context, AEditableBaseView aEditableBaseView, int n) {
        return AEditableUtil.createColorLayout(new APopupColorButton(context, "resource/popup_icon_color@2x.png", n, 100000, aEditableBaseView));
    }

    static int RGBToBGR(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        return Color.rgb((int)n4, (int)n3, (int)n2);
    }

    static Bitmap getBitmapFromAssetPath(Context context, String string) {
        Bitmap bitmap = null;
        try {
            InputStream inputStream = context.getAssets().open(OZStorage.getImagePath(string));
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bitmap;
    }

    static Drawable getDrawableFromAssetPath(Context context, String string) {
        Drawable drawable2 = null;
        try {
            drawable2 = Drawable.createFromStream((InputStream)context.getAssets().open(OZStorage.getImagePath(string)), null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return drawable2;
    }

    static Drawable getOZDrawableFromAssetPath(Context context, String string) {
        Drawable drawable2 = null;
        if (string != null) {
            try {
                drawable2 = OZStorage.getDrawableFromAssetsPath(context, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return drawable2;
    }

    static int checkArrayIndex(int n, Object[] objectArray) {
        return Math.min(objectArray.length - 1, Math.max(0, n));
    }

    static String getConvert10to16(int n, int n2, int n3) {
        return (Integer.toString(n, 16).length() == 1 ? "0" + Integer.toString(n, 16) : Integer.toString(n, 16)) + (Integer.toString(n2, 16).length() == 1 ? "0" + Integer.toString(n2, 16) : Integer.toString(n2, 16)) + (Integer.toString(n3, 16).length() == 1 ? "0" + Integer.toString(n3, 16) : Integer.toString(n3, 16));
    }
}

