/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.history.adapter;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.util.Base64;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import oz.main.OZStorage;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.history.HistoryNavigationCompData;
import oz.viewer.ui.history.HistoryNavigationData;
import oz.viewer.ui.history.HistoryNavigationManager;
import oz.viewer.ui.history.HistoryNavigationUtil;
import oz.viewer.ui.history.adapter.Adapter$1;
import oz.viewer.ui.history.adapter.Adapter$CustomSimpleOnGestureListener;
import oz.viewer.ui.history.adapter.Adapter$OnClickListener;
import oz.viewer.ui.history.adapter.CompItem;
import oz.viewer.ui.history.adapter.CompPageSectionItem;
import oz.viewer.ui.history.adapter.Item;
import oz.viewer.ui.history.adapter.RevisionItem;

public class Adapter
extends BaseAdapter
implements View.OnClickListener {
    private static final int MODE_REVISION_TABLET = 0;
    private static final int MODE_REVISION_PHONE = 1;
    private static final int MODE_COMP_SIMPLE = 2;
    private static final int MODE_COMP_DETAIL = 3;
    private static final byte[] MAGIC_NUMBER_PDF = new byte[]{37, 80, 68, 70, 45};
    private HistoryNavigationManager mManager;
    private ArrayList mItems;
    private int mMode;
    private Adapter$OnClickListener mListener;
    private Dialog mShowDialog;
    Adapter$CustomSimpleOnGestureListener mTouchListener;

    public Adapter(HistoryNavigationManager historyNavigationManager) {
        this.mManager = historyNavigationManager;
        this.mItems = new ArrayList();
        this.mTouchListener = new Adapter$CustomSimpleOnGestureListener(this);
        this.setRevisionTabletMode();
    }

    public void dismiss() {
        this.dismissDialog();
    }

    private void dismissDialog() {
        if (this.mShowDialog != null) {
            if (this.mShowDialog.isShowing()) {
                this.mShowDialog.dismiss();
            }
            this.mShowDialog = null;
        }
    }

    public void setRevisionTabletMode() {
        this.mMode = 0;
    }

    public void setRevisionPhoneMode() {
        this.mMode = 1;
    }

    public void setCompSimpleMode() {
        this.mMode = 2;
    }

    public void setCompDetailMode() {
        this.mMode = 3;
    }

    private boolean isMode(int n) {
        return this.mMode == n;
    }

    public boolean isRevisionTabletMode() {
        return this.isMode(0);
    }

    public boolean isRevisionPhoneMode() {
        return this.isMode(1);
    }

    public boolean isCompSimpleMode() {
        return this.isMode(2);
    }

    public boolean isCompDetailMode() {
        return this.isMode(3);
    }

    public int getCount() {
        return this.mItems.size();
    }

    public Object getItem(int n) {
        return this.mItems.get(n);
    }

    public long getItemId(int n) {
        return n;
    }

    public View getView(int n, View view, ViewGroup viewGroup) {
        Item item = (Item)this.getItem(n);
        if (view == null) {
            view = new FrameLayout(viewGroup.getContext());
            ((ViewGroup)view).addView(item.createView(viewGroup.getContext()), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        }
        item.updateView(viewGroup.getContext(), view.findViewById(10000));
        view.setTag((Object)item);
        return view;
    }

    public int getItemViewType(int n) {
        return ((Item)this.mItems.get((int)n)).type;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public boolean isEmpty() {
        if (this.mManager == null) {
            return true;
        }
        return this.mManager.getRevisionSize() == 0 && this.mManager.getItemSize() == 0;
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean isEnabled(int n) {
        return true;
    }

    public void notifyDataSetChanged() {
        this.update();
        super.notifyDataSetChanged();
    }

    public void notifyDataSetInvalidated() {
        this.update();
        super.notifyDataSetInvalidated();
    }

    public void update() {
        this.mItems.clear();
        switch (this.mMode) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.mManager.getRevisionSize(); ++j) {
                    this.mItems.add(new RevisionItem(this, this.mManager, this.mManager.getRevision(j)));
                }
                break;
            }
            case 2: 
            case 3: {
                ArrayList arrayList;
                int n;
                HistoryNavigationCompData historyNavigationCompData;
                if (this.mManager.getSelectedRevision() < 0) break;
                boolean bl = this.mMode == 2;
                ArrayList<HistoryNavigationCompData> arrayList2 = null;
                ArrayList arrayList3 = this.mManager.getItems();
                arrayList2 = new ArrayList<HistoryNavigationCompData>();
                int n2 = this.mManager.getRevision(this.mManager.getSelectedRevision()).getRevisionVersion();
                for (int j = 0; j < arrayList3.size(); ++j) {
                    historyNavigationCompData = (HistoryNavigationCompData)arrayList3.get(j);
                    if (historyNavigationCompData.version > n2) continue;
                    arrayList2.add(historyNavigationCompData);
                }
                if (bl) {
                    ArrayList arrayList4 = new ArrayList();
                    historyNavigationCompData = HistoryNavigationManager.getItemUniqueZOrders(arrayList2);
                    for (n = 0; n < historyNavigationCompData.size(); ++n) {
                        int n3 = historyNavigationCompData.keyAt(n);
                        arrayList = HistoryNavigationManager.findItemsByUniqueZOrder(arrayList2, n3);
                        arrayList4.add(arrayList.get(0));
                    }
                    arrayList2 = arrayList4;
                }
                SparseIntArray sparseIntArray = HistoryNavigationManager.getItemPages(arrayList2);
                for (int j = 0; j < sparseIntArray.size(); ++j) {
                    n = sparseIntArray.keyAt(j);
                    this.mItems.add(new CompPageSectionItem(this, this.mManager, n));
                    ArrayList arrayList5 = HistoryNavigationManager.findItemsByPage(arrayList2, n);
                    arrayList = HistoryNavigationManager.getItemUniqueZOrders(arrayList5);
                    for (int k = 0; k < arrayList.size(); ++k) {
                        this.mItems.add(new CompItem(this, this.mManager, HistoryNavigationManager.findItemsByUniqueZOrder(arrayList5, arrayList.keyAt(k))));
                    }
                }
                break;
            }
        }
    }

    public void onClick(View view) {
        boolean bl = false;
        if (this.mListener != null) {
            bl = this.mListener.onClick(this.mManager.getListView(), this.mManager, this, view);
        }
        if (!bl) {
            switch (view.getId()) {
                case 10000: {
                    Item item;
                    if (view.getParent() == null || ((View)view.getParent()).getTag() == null || !((item = (Item)((View)view.getParent()).getTag()) instanceof RevisionItem)) break;
                    HistoryNavigationData historyNavigationData = (HistoryNavigationData)item.obj;
                    if (!this.isRevisionPhoneMode() && this.mManager.getSelectedRevision() >= 0 && historyNavigationData.equals(this.mManager.getRevision(this.mManager.getSelectedRevision()))) break;
                    this.mManager.setSelectedRevision(historyNavigationData);
                    this.mManager.setSelectedItem(-1);
                    this.mManager.updateListView();
                    break;
                }
                case 10001: 
                case 11002: {
                    if (view.getTag() == null || !(view.getTag() instanceof HistoryNavigationCompData)) break;
                    HistoryNavigationCompData historyNavigationCompData = (HistoryNavigationCompData)view.getTag();
                    if (this.mManager.getSelectedItem() >= 0 && historyNavigationCompData.equals(this.mManager.getItem(this.mManager.getSelectedItem()))) break;
                    this.mManager.setSelectedItem(historyNavigationCompData);
                    this.mManager.updateListView(1);
                    break;
                }
                case 10011: 
                case 10012: 
                case 10013: 
                case 10014: {
                    this.onBtnClick(view, (HistoryNavigationCompData)view.getTag(), OZStorage.isSmallDevice(view.getContext()));
                }
            }
        }
    }

    public void setOnClickListener(Adapter$OnClickListener adapter$OnClickListener) {
        this.mListener = adapter$OnClickListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static byte[] decompress(byte[] byArray) {
        block30: {
            byte[] byArray2;
            block31: {
                IOException iOException2222;
                GZIPInputStream gZIPInputStream;
                ByteArrayOutputStream byteArrayOutputStream;
                ByteArrayInputStream byteArrayInputStream;
                block26: {
                    block25: {
                        int n;
                        if (byArray == null) break block30;
                        int n2 = 32;
                        byArray2 = null;
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        gZIPInputStream = null;
                        gZIPInputStream = new GZIPInputStream((InputStream)byteArrayInputStream, 32);
                        byte[] byArray3 = new byte[32];
                        while ((n = gZIPInputStream.read(byArray3)) != -1) {
                            byteArrayOutputStream.write(byArray3, 0, n);
                        }
                        if (byteArrayOutputStream.size() <= 0) break block25;
                        byArray2 = byteArrayOutputStream.toByteArray();
                    }
                    Object var9_9 = null;
                    if (gZIPInputStream == null) break block26;
                    try {
                        gZIPInputStream.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (byteArrayInputStream != null) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException2222) {}
                }
                break block31;
                {
                    catch (Exception exception) {
                        IOException iOException32222;
                        Object var9_10 = null;
                        if (gZIPInputStream != null) {
                            try {
                                gZIPInputStream.close();
                            }
                            catch (IOException iOException32222) {
                                // empty catch block
                            }
                        }
                        if (byteArrayInputStream != null) {
                            try {
                                byteArrayInputStream.close();
                            }
                            catch (IOException iOException32222) {
                                // empty catch block
                            }
                        }
                        if (byteArrayOutputStream != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (IOException iOException32222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException42222;
                    Object var9_11 = null;
                    if (gZIPInputStream != null) {
                        try {
                            gZIPInputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (byteArrayInputStream != null) {
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            return byArray2;
        }
        return null;
    }

    private void onBtnClick(View view, HistoryNavigationCompData historyNavigationCompData, boolean bl) {
        if (historyNavigationCompData != null) {
            int n;
            boolean bl2 = true;
            ImageView imageView = null;
            int n2 = 0;
            int n3 = 0;
            Dialog dialog = null;
            LinearLayout linearLayout = new LinearLayout(view.getContext());
            linearLayout.setBackgroundColor(-1);
            linearLayout.setOrientation(1);
            linearLayout.setPadding(0, 0, 0, 0);
            int n4 = OZStorage.DpToPx(view.getContext(), 10.0f, true);
            FrameLayout frameLayout = new FrameLayout(view.getContext());
            frameLayout.setBackgroundColor(HistoryNavigationUtil.COLOR_LT_LT_GRAY);
            frameLayout.setPadding(n4, n4, n4, n4);
            TextView textView = new TextView(view.getContext());
            textView.setSingleLine();
            textView.setTextColor(HistoryNavigationUtil.COLOR_DK_DK_GRAY);
            textView.setText((CharSequence)historyNavigationCompData.name);
            textView.setTextSize(2, 20.0f);
            textView.setTypeface(null, 1);
            textView.setGravity(17);
            Button button = new Button(view.getContext());
            button.setText((CharSequence)OZAndroidResource.getResource("close.label"));
            button.setTextColor(HistoryNavigationUtil.COLOR_SKY_BLUE);
            button.setTextSize(2, OZStorage.isViewerLanguageEquals(Locale.ENGLISH) ? 16.0f : 18.0f);
            button.setTypeface(null, 1);
            button.setBackgroundDrawable(null);
            button.setPadding(0, 0, 0, 0);
            button.setMinWidth(0);
            frameLayout.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 17));
            frameLayout.addView((View)button, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(OZStorage.DpToPx(view.getContext(), 65.0f, true), OZStorage.DpToPx(view.getContext(), 40.0f, true), 19));
            n2 = OZStorage.DpToPx(view.getContext(), 500.0f, true);
            n3 = OZStorage.DpToPx(view.getContext(), 500.0f, false);
            if (historyNavigationCompData.compType == 82 || historyNavigationCompData.compType == 58 || historyNavigationCompData.compType == 57 || historyNavigationCompData.compType == 89) {
                String string;
                int n5;
                boolean bl3 = false;
                n = 0;
                byte[] byArray = null;
                String string2 = null;
                if (historyNavigationCompData.compType == 57) {
                    if (historyNavigationCompData.value.startsWith("data:image/ozvp;")) {
                        n = 1;
                        byArray = this.mManager.getMainFrameView().nativeGetSignImage(historyNavigationCompData.value, n2, n3, historyNavigationCompData.id, historyNavigationCompData.getPage(), historyNavigationCompData.name, 0);
                    } else if (historyNavigationCompData.value.startsWith("data:image/ozpt;")) {
                        n = 1;
                        byArray = this.mManager.getMainFrameView().nativeGetSignImage(historyNavigationCompData.value, n2, n3, historyNavigationCompData.id, historyNavigationCompData.getPage(), historyNavigationCompData.name, 1);
                    }
                } else if (historyNavigationCompData.value.startsWith("data:application/x-gzip-compressed;base64,")) {
                    bl3 = true;
                }
                if (n == 0) {
                    n5 = historyNavigationCompData.value.indexOf(";base64,");
                    string = null;
                    if (n5 > 0) {
                        string2 = historyNavigationCompData.value.substring(5, n5);
                        string = historyNavigationCompData.value.substring(n5 + 8);
                        byArray = Base64.decode((String)string, (int)2);
                    } else {
                        Log.e((String)"OZViewer", (String)"### item.value invalid data !!");
                        bl2 = false;
                    }
                }
                if (byArray != null) {
                    if (bl3) {
                        byArray = Adapter.decompress(byArray);
                    }
                    if (historyNavigationCompData.compType == 58) {
                        Intent intent = new Intent("android.intent.action.VIEW");
                        string = "/OZVoiceRecorder_history.m4a";
                        Uri uri = null;
                        Context context = view.getContext();
                        try {
                            if (Build.VERSION.SDK_INT >= 29) {
                                File file = new File(context.getFilesDir(), string);
                                if (file.exists()) {
                                    file.delete();
                                }
                                FileOutputStream fileOutputStream = new FileOutputStream(file);
                                fileOutputStream.write(byArray);
                                fileOutputStream.close();
                                uri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileprovider"), (File)file);
                            } else {
                                String string3 = OZStorage.tmpCacheDir + string;
                                File file = new File(string3);
                                if (file.exists()) {
                                    file.delete();
                                }
                                FileOutputStream fileOutputStream = new FileOutputStream(file);
                                fileOutputStream.write(byArray);
                                fileOutputStream.close();
                                uri = Uri.fromFile((File)file);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        intent.setDataAndType(uri, string2);
                        intent.addFlags(1);
                        ((Activity)view.getContext()).startActivityForResult(intent, 13101);
                        bl2 = false;
                    } else if (historyNavigationCompData.compType == 82 || historyNavigationCompData.compType == 57 || historyNavigationCompData.compType == 89) {
                        n5 = 0;
                        if (historyNavigationCompData.compType == 89 && byArray.length > MAGIC_NUMBER_PDF.length) {
                            n5 = 1;
                            for (int j = 0; j < MAGIC_NUMBER_PDF.length; ++j) {
                                if (MAGIC_NUMBER_PDF[j] == byArray[j]) continue;
                                n5 = 0;
                                break;
                            }
                        }
                        if (n5 == 0) {
                            Bitmap bitmap = null;
                            try {
                                bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ImageView imageView2 = new ImageView(view.getContext());
                            if (bitmap != null) {
                                imageView2.setImageBitmap(bitmap);
                            }
                            imageView2.setScaleType(ImageView.ScaleType.FIT_CENTER);
                            imageView = imageView2;
                        } else {
                            Intent intent = new Intent("android.intent.action.VIEW");
                            String string4 = "/OZAttachment_history.pdf";
                            Uri uri = null;
                            Context context = view.getContext();
                            try {
                                if (Build.VERSION.SDK_INT >= 29) {
                                    File file = new File(context.getFilesDir(), string4);
                                    if (file.exists()) {
                                        file.delete();
                                    }
                                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                                    fileOutputStream.write(byArray);
                                    fileOutputStream.close();
                                    uri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileprovider"), (File)file);
                                } else {
                                    String string5 = OZStorage.tmpCacheDir + string4;
                                    File file = new File(string5);
                                    if (file.exists()) {
                                        file.delete();
                                    }
                                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                                    fileOutputStream.write(byArray);
                                    fileOutputStream.close();
                                    uri = Uri.fromFile((File)file);
                                }
                            }
                            catch (Exception exception) {
                                Log.e((String)"OZViewer", (String)"Not exists FileProvider or filePaths.xml");
                                exception.printStackTrace();
                            }
                            string2 = "application/pdf";
                            intent.setDataAndType(uri, string2);
                            intent.addFlags(1);
                            ((Activity)view.getContext()).startActivityForResult(intent, 13102);
                            bl2 = false;
                        }
                    }
                }
            }
            this.dismissDialog();
            if (bl2) {
                linearLayout.addView((View)frameLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                if (imageView != null) {
                    FrameLayout frameLayout2 = new FrameLayout(view.getContext());
                    n = n4 / 2;
                    frameLayout2.setPadding(n, n, n, n);
                    frameLayout2.addView(imageView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    if (bl) {
                        linearLayout.addView((View)frameLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                    } else {
                        linearLayout.addView((View)frameLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n2, n3));
                    }
                }
                if (bl) {
                    dialog = new Dialog(view.getContext(), 16973830);
                } else {
                    dialog = new Dialog(view.getContext(), 16973835);
                    dialog.requestWindowFeature(1);
                }
                button.setTag((Object)dialog);
                button.setOnClickListener((View.OnClickListener)new Adapter$1(this));
                dialog.setContentView((View)linearLayout);
                dialog.setCancelable(false);
                dialog.show();
                this.mShowDialog = dialog;
            }
        }
    }
}

