package jp.agentec.abook.abv.bl.acms.client.json;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.type.AuthLevel;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

import org.json.adf.JSONException;
import org.json.adf.JSONObject;

/**
 * {@link AcmsClient#getAuthLevel} の戻り値です。
 */
public class AuthLevelJSON extends AcmsCommonJSON {
	public static final String KeyAuthLevel = "authLevel";
	
	public int authLevel; // ユーザの権限レベル
	
	public AuthLevelJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONException, JSONValidationException {
		super.parse(json);
		authLevel = getInt(json, KeyAuthLevel, AuthLevel.MOBILE);
	}
}
