package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;

public class MyInfoJSON extends AcmsCommonJSON {

    public ShopMemberDto shopMemberDto;

    public MyInfoJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }

        JSONObject MyInfoJson = json.getJSONObject(ABookCommConstants.KEY.BODY);
        if (MyInfoJson == null) { return; }

        shopMemberDto = new ShopMemberDto();
        //ArrayList<Integer> groupIdList = new ArrayList<Integer>();
        /*JSONArray groupIdJsonArray = (JSONArray) MyInfoJson.get(ABookCommConstants.KEY.GROUP_ID_LIST);
        for (int i = 0; i < groupIdJsonArray.length(); i++) {
            groupIdList.add(groupIdJsonArray.getInt(i));
        }*/
        //shopMemberDto.groupIdList = groupIdList;
        shopMemberDto.selfFlg = ABookCommConstants.FLAG.SELF_FLAG.ON;
        shopMemberDto.profileUrl = MyInfoJson.getString(ABookCommConstants.KEY.PROFILE_IMAGE_PATH);
        shopMemberDto.shopMemberId = MyInfoJson.getInt(ABookCommConstants.KEY.SHOP_MEMBER_ID);
        shopMemberDto.shopMemberName = MyInfoJson.getString(ABookCommConstants.KEY.MEMBER_NAME);
        if (MyInfoJson.has(ABookCommConstants.KEY.LOGIN_ID)) {
            shopMemberDto.loginId = MyInfoJson.getString(ABookCommConstants.KEY.LOGIN_ID);
        }
    }
}

