package jp.agentec.abook.abv.bl.acms.client.json.content;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

public class PageInfoJSON extends AbstractJSON {
	// ルート
	public static final String PAGE_INFO = "pagesInfo";

	// ページ情報関連
	public static final String PAGE_NO = "pageNo";
	public static final String PAGE_WIDTH = "pageWidth";
	public static final String PAGE_HEIGHT = "pageHeight";

	public PageInfoJSON(String json) {
		super(json);
	}

	/**
	 * 指定したページのJSONObjectをPageInfoJSONDataに変換して返します
	 * 
	 * @param pageNumber 0 origin
	 * @return
	 */
	public PageInfoJSONData getPageData(int pageNumber) {
		PageInfoJSONData result = null;
		JSONArray pageInfo = root.getJSONArray(PAGE_INFO);

		for (int i = 0; i < pageInfo.length(); i++) {
			JSONObject obj = pageInfo.getJSONObject(i);
			if (pageNumber == (obj.getInt(PAGE_NO) - 1)) {
				result = parse(obj);
				break;
			}
		}
		return result;
	}

	public PageInfoJSONData parse(JSONObject obj) {
		PageInfoJSONData pageInfoJSONData = new PageInfoJSONData();
		// Jsonは1から始まるので-1
		pageInfoJSONData.pageNo = obj.getInt(PageInfoJSON.PAGE_NO) - 1;
		pageInfoJSONData.pageWidth = obj.getInt(PageInfoJSON.PAGE_WIDTH);
		pageInfoJSONData.pageHeight = obj.getInt(PageInfoJSON.PAGE_HEIGHT);
		return pageInfoJSONData;
	}

	public class PageInfoJSONData {
		public int pageNo;
		public int pageWidth;
		public int pageHeight;
	}
}
