package jp.agentec.abook.abv.bl.acms.client.json.content;

import jp.agentec.abook.abv.bl.common.log.Logger;

import org.json.adf.JSONException;
import org.json.adf.JSONObject;

public class PageObjectJSON extends AbstractJSON {
	private int pageNumber;
	
	public PageObjectJSON(JSONObject pageObject) {
		super(pageObject);
	}
	
	/**
	 * BUTTON_TYPE = 1, 
	 * VIDEO_TYPE = 2, 
	 * MUSIC_TYPE = 3, 
	 * CHANGE_IMAGE_TYPE = 4,
	 * CHANGE_VIDEO_TYPE = 5,
	 * TRIGGER_TYPE = 6, 
	 * RICH_TEXT_TYPE = 7
	 * ENQUETE_TYPE = 11;
	 * @return mediaType
	 */
	public int getMediaType() {
		return root.getInt("mediaType");
	}
	
	public MediaInfoJSON getMediaInfo() {
		MediaInfoJSON infoJSON = null;
		try {
			infoJSON = new MediaInfoJSON(root.getJSONObject("mediaInfo"));
		} catch (JSONException e) {
			// Nothing
			Logger.e("PageObjectJSON", "JSONException:mediaInfo");
		}
		return infoJSON;
	}
	
	public ActionInfoJSON getActionInfo() {
		return new ActionInfoJSON(root.getJSONObject("action"));
	}
	
	public LocationJSON getLocation() {
		LocationJSON locationJSON = null;
		try {
			locationJSON = new LocationJSON(root.getJSONObject("location"));
		} catch (JSONException e) {
			// Nothing
			Logger.e("PageObjectJSON", "JSONException:location");
		}
		return locationJSON;
	}
	
	public void setPageNumber(int pageNumber) {
		this.pageNumber = pageNumber;
	}
	public int getPageNumber() {
		return pageNumber;
	}
	
}
