package jp.agentec.abook.abv.bl.acms.client.parameters;

import java.util.Locale;

import jp.agentec.abook.abv.bl.common.util.SecurityUtil;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.adf.net.http.HttpParameterObject;
import jp.agentec.adf.util.StringUtil;

public abstract class AbstractAcmsLoginParameters extends HttpParameterObject {
	/**
	 * ユーザのログインIDです。
	 * @since 1.0.0
	 */
	protected String loginId;
	/**
	 * ユーザのパスワードです。
	 * @since 1.0.0
	 */
	protected String password;
	/**
	 * アプリケーションIDです。
	 * @since 1.0.0
	 */
	protected int appId;
	/**
	 * アプリケーションの現在バージョンです。
	 * @since 1.0.0
	 */
	protected String appVersion;
	/**
	 * 端末タイプです。
	 * @since 1.0.0
	 */
	protected int deviceTypeId;
	/**
	 * デバイストークンです。
	 * @since 1.0.0
	 */
	protected String deviceToken;
	/**
	 * 端末のMACアドレスです。 
	 * @since 1.0.0
	 */
	protected String ma;
	
	/**
	 * {@link NewAppStoreLoginParameters} クラスのインスタンスを初期化します。
	 * @param loginId ユーザのログインIDです。半角英数字と'_'、'-'のみ使えます。
	 * @param memberPassword ユーザのパスワードです。半角英数字と'_'、'-'のみ使えます。
	 * @param appId アプリケーションIDです。
	 * @param appVersion アプリケーションの現在バージョンです。
	 * @param deviceToken デバイストークンです。
	 * @param deviceTypeId 端末タイプです。
	 * @param ma 端末のMACアドレスです。 
	 * @throws IllegalArgumentException 引数のどれかが半角英数字と'_'、'-'ではありません。
	 * @since 1.0.0
	 */
	public AbstractAcmsLoginParameters(String loginId, String memberPassword, int appId, String appVersion
			, int deviceTypeId, String deviceToken, String ma) throws IllegalArgumentException {
		
		if (StringUtil.isNullOrWhiteSpace(appVersion)) {
			throw new IllegalArgumentException("argument appVersion not allowed null or white space.");
		}

		this.loginId = loginId;
		this.password = memberPassword;
		this.appId = appId;
		this.appVersion = appVersion;
		this.deviceTypeId = deviceTypeId;
		this.deviceToken = deviceToken;
		this.ma = ma;
	}
	/**
	 *  ユーザのログインIDを取得します。
	 * @return ユーザのログインIDです。
	 * @since 1.0.0
	 */
	public String getLoginId() {
		return loginId;
	}
	/**
	 * ユーザのパスワードを取得します。
	 * @return ユーザのパスワードです。
	 * @since 1.0.0
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * アプリケーションIDを取得します。
	 * @return アプリケーションID
	 * @since 1.0.0
	 */
	public int getAppId() {
		return appId;
	}
	/**
	 * アプリケーションの現在バージョンを取得します。
	 * @return アプリケーションの現在バージョンです。
	 * @since 1.0.0
	 */
	public String getAppVersion() {
		return appVersion;
	}
	/**
	 * 端末タイプを返します。
	 * @return 端末タイプです。
	 * @since 1.0.0
	 */
	public int getDeviceTypeId() {
		return deviceTypeId;
	}
	/**
	 * デバイストークンを取得します。
	 * @return デバイストークンです。
	 * @since 1.0.0
	 */
	public String getDeviceToken() {
		return deviceToken;
	}
	/**
	 * 端末のMACアドレスを取得します。
	 * @return 端末のMACアドレスです。
	 * @since 1.0.0
	 */
	public String getMa() {
		return ma;
	}

	/**
	 * システムの言語コードを返します。
	 * @since 1.1.0
	 */
	public String getLanguage() {
		return Locale.getDefault().getLanguage();
	}
}
