package jp.agentec.abook.abv.bl.acms.type;

/**
 * ダウンロード状態を示します。
 * @author Taejin Hong
 * @version 1.0.0
 */
public enum DownloadStatusType {
	/**
	 *  ダウンロード待機
	 * @since 1.0.0
	 */
	Waiting("W1", "waiting"),
	/**
	 * リソースダウンロード開始
	 * @since 1.0.0
	 */
	Downloading("D1", "downloading"),
	/**
	 * リソースダウンロードの一時停止
	 * @since 1.0.0
	 */
	Paused("P1", "paused"),
	/**
	 * ネットワーク切断による自動停止
	 * typeの文字列がPauseと同様であることに注意
	 * @since 1.0.0
	 */
	AutoPaused("P1", "auto paused"),
	/**
	 * 初期化
	 * @since 1.0.0
	 */
	Initializing("I", "Initilalizing"),
	/**
	 * 失敗
	 * @since 1.0.0
	 */
	Failed("F", "failed"),
	/**
	 * 終了
	 * @since 1.0.0
	 */
	Succeeded("S", "succeeded"),
	/**
	 * キャンセル
	 * @since 1.0.0
	 */
	Canceled("C", "canceled"),
	/**
	 * 初期状態
	 * @since 1.6.0
	 */
	None("N", "none");
	
	
	private String downloadStatus;
	private String displayStr;
	
	DownloadStatusType(String downloadStatus, String displayStr) {
		this.downloadStatus = downloadStatus;
		this.displayStr = displayStr;
	}
	
	/**
	 * ダウンロード状態のコード番号を返します。
	 * @return　ダウンロード状態のコード番号です。
	 * @since 1.0.0
	 */
	public String type() {
		return downloadStatus;
	}
	
	public String display() {
		return displayStr;
	}
	
	public static DownloadStatusType parse(String status) {
		if (status == null) {
			return DownloadStatusType.None;
		}
		
		DownloadStatusType type;
		
		if (status.equals(Waiting.type())) {
			type = DownloadStatusType.Waiting;
		} else if (status.equals(Downloading.type())) {
			type = DownloadStatusType.Downloading;
		} else if (status.equals(Initializing.type())) {
			type = DownloadStatusType.Initializing;
		} else if (status.equals(Failed.type())) {
			type = DownloadStatusType.Failed;
		} else if (status.equals(Succeeded.type())) {
			type = DownloadStatusType.Succeeded;
		} else if (status.equals(Paused.type())) {
			type = DownloadStatusType.Paused;
		} else if (status.equals(Canceled.type())) {
			type = DownloadStatusType.Canceled;
		} else {
			type = DownloadStatusType.None;
		}
		
		return type;
	}
}
