package jp.agentec.abook.abv.bl.acms.type;

/**
 * Created by leej on 2019/08/21.
 */

public enum  OperationSortingType {
    OperationName(0),
    OperationStartDateDESC(1),
    OperationStartDateASC(2),
    OperationType(3),
    ReadingDate(4);

    private final int operationSorting;

    OperationSortingType(int operationSorting) {
        this.operationSorting = operationSorting;
    }

    /**
     * 検索をかける項目の番号を返します。
     * @return　検索をかける項目の番号です。
     * @since 1.0.0
     */
    public int type() {
        return operationSorting;
    }

    /**
     * 指定した数字に対応するSecurityPolicyCodeの値を返します。
     * @param operationSorting 数字のコードです。
     * @return　指定した数字に対応するSearchDivisionTypeの値です。
     * @since 1.0.0
     */
    public static OperationSortingType parse(int operationSorting) {
        OperationSortingType sortingType;

        switch (operationSorting) {
            case 0:     // 作業名
                sortingType = OperationSortingType.OperationName;
                break;
            case 1:     // 作業期間が新しい順
                sortingType = OperationSortingType.OperationStartDateDESC;
                break;
            case 2:     // 作業時間が古い順
                sortingType = OperationSortingType.OperationStartDateASC;
                break;
            case 3:     // 報告タイプ
                sortingType = OperationSortingType.OperationType;
                break;
            case 4:     // 閲覧日が新しい順
                sortingType = OperationSortingType.ReadingDate;
                break;
            default:    // 作業名（デフォルト）
                sortingType = OperationSortingType.OperationName;
                break;
        }
        return sortingType;
    }
}
