package jp.agentec.abook.abv.bl.acms.type;

/**
 * 契約事業者のサービスオプションのセキュリティポリシーコードです。<br>
 * パスワード強制変更等のオプションに値として使われる数字に対応しています。
 * @author Taejin Hong
 * @version 1.0.0
 */
public enum SecurityPolicyType {
	/**
	 * なし
	 * @since 1.0.0
	 */
	None(0),
	/**
	 * 催促
	 * @since 1.0.0
	 */
	Reminder(1),
	/**
	 * 強制
	 * @since 1.0.0
	 */
	Enforcement(2);
	
	private final int code;
	
	SecurityPolicyType(int code) {
		this.code = code;
	}
	
	/**
	 * 数字のコードを返します。
	 * @return 数字のコードです。
	 * @since 1.0.0
	 */
	public int PolicyCode() {
		return code;
	}
	
	/**
	 * 指定した数字に対応するSecurityPolicyCodeの値を返します。
	 * @param code 数字のコードです。
	 * @return　指定した数字に対応するSecurityPolicyCodeの値です。
	 * @since 1.0.0
	 */
	public static SecurityPolicyType parse(int code) {
		SecurityPolicyType policyType;
		
		switch (code) {
		case 1:
			policyType = SecurityPolicyType.Reminder;
			break;
		case 2:
			policyType = SecurityPolicyType.Enforcement;
			break;
		case 0:
		default:
			policyType = SecurityPolicyType.None;
			break;
		}
		
		return policyType;
	}
}
