package jp.agentec.abook.abv.bl.common;

public class Constant {
	public interface AlertMessageLevel {
		int NONE = 0;		// なし
		int MESSAGE = 1;	// メッセージ
		int PASSWORD = 2;	// パスワード
	}

	public interface EventType {
		String SINGLE_TAP = "1";
		String DOUBLE_TAP = "2";
		String LONG_PRESS = "3";
		String PINCH_IN = "4";
		String PINCH_OUT = "5";
		String SWIPE = "6";
		String FLICK = "7";
	}
	
	public interface SlideAnimationType {
		int NO = 0;
		int FADE = 1;
		int SCALING = 2;
		int FLIP = 4;
	}

	public interface BackupFileType {
		String Memo = "1";
		String Marking = "2";
		String Bookmark = "4";
	}

	public interface AspectType {
		String ASPECT_RATIO_16_9 = "16_9";
		String ASPECT_RATIO_9_16 = "9_16";
		String ASPECT_RATIO_4_3 = "4_3";
		String ASPECT_RATIO_3_4 = "3_4";
	}

	public interface BackupFileName {
		String Memo = "ContentMemo.json";
		String Marking = "Marking.json";
		String Bookmark = "Bookmark.json";
	}

	public interface ReaderConstant {
		String SHARED_SECRET_REPO = "YqI96#T%vsD3op2v";
		String SHARED_SECRET_CMS = "T91q6#Y$vsdE0PzU";
		long SITEID_IN_CONTENTID_FOLD = 10000000000L; // コンテンツIDにおけるサイトIDの桁数（11桁）
		
		interface ReceivePushMessage{
			int NOT_SET = 0;
			int PERMIT = 1;
			int REFUSE = 2;
		}
	}
	
	public interface ReadingLogMode {
		int DEFAULT = 0;
	}
	
	public interface ExceptionDetailMessage {
		String SERVER_IS_DISCONNECTED = "server is disconnected.";

	}

	public interface DeviceIdType {
		int MAC_ADDRESS = 0;
		int ANDROID_ID = 1;
		int UUID = 2;
	}

	public interface ApiValue {
		int nuapi = 0;
		int abvapi = 1;
		int checkapi = 2;
		int chatapi = 3;  // チャット
	}

	public interface XWalkOpenType {
		int DEFAULT = -1;
		int TASK_DERECTION = 1;
		int TASK_REPORT = 2;
		int PANO_EDIT = 3;
	}

	public interface ABookCheck {
		String XWALK_OPEN_TYPE = "xwalkOpenType";
		String REPORT_GPS = "reportGps";
	}

	public interface PushMessageSendType {
		int InGroup = 0;
		int AllOperation = 1;
	}

	public interface HelpViewType {
		int OperationListDirector = 0;
		int OperationListReporter = 1;
		int OperationDetail = 2;
		int PanoContentEdit = 3;
		int ListOperationDirector = 4;
		int ListOperationReporter = 5;
		int DrawingOperationDirector = 6;
		int DrawingOperationReporter = 7;
		int PanoOperationDirector = 8;
		int PanoOperationReporter = 9;
		int DirectorTask = 10;
		int ReportTask = 11;
		int DirectorTaskList = 12;
		int ReportTaskList = 13;
		int ReportPreview = 14;
		int CommonContent = 15;
		int RoutineTaskOperation = 16;
        int RoutineTaskOperationReport = 17;
	}

	public interface XWalkWebViewDisplayStatus {
		int InitView = 0;
		int TaskView = 1;
		int ReportPreView = 2;
		int TaskListView = 3;
	}

	public interface ABookPermissionType {
		int ReadExternalStorage = 0;
		int AccessFineLocation = 1;
		int Camera = 2;
		int Audio =3;
		int Bluetooth = 4;
	}

	public interface TaskReportLevel {
		int ReportType = 0;				// 報告タイプ
		int ReportReplyType = 1;		// 報告（回答）タイプ
	}

	public interface ReportType {
		int Report = 0;  // 報告
		int RoutineTask = 1;  // 定期点検
		int ReportReply = 2;  // 報告（回答）
		int ReportContinuous = 3;  // 連続作業
	}

	public interface operationType {
		int LIST = 0;
		int DRAWING = 1;
		int CONTENT360 = 2;

	}

	// 報告履歴管理
	public interface EnableReportHistory {
		int Invalid = 0;			// 無効
		int Enable = 1;			// 有効
	}

	// 作業編集可能区分
	public interface EnableReportEdit {
		int NO = 0;
		int YES = 1;
	}

	// 作業可能区分
	public interface EnableEditReport {
		int NO = 0;
		int YES = 1;
	}

	// 作業追加区分
	public interface EnableAddReport {
		int NO = 0;
		int YES = 1;
	}

	// 点検後修正可
	public interface EnableReportUpdate {
		int NO = 0;
		int YES = 1;
	}

	//Wifiスキャンタイプ
	public interface WifiScanType {
		int CloseCameraActivity = 0;
		int ThetaConnectError = 1;
	}

	// 連携機器の区分
	public interface DeviceType {
//		int centerThermomete = 1;  // 中心温度計
//		int sensor = 2; // 置くだけセンサー
//		int barcode = 3; // バーコード
//		int radiationThermomete = 4; // 放射温度計
//		int sppBluetoothMachine = 5; // SPP通信機器
//		int nfc = 6; // nfc機器
		int alcoholChecker = 0; // アルコールチェッカー
	}
}
