package jp.agentec.abook.abv.bl.common.exception;

/**
 * 通信を行う機能において、ネットワークにつながらず、その機能の実行ができないことを示します。<br>
 * {@link Exception} を継承しているが、独自の機能は持っていません。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class NetworkDisconnectedException extends Exception {
	private static final long serialVersionUID = -6474288923886724797L;

	/**
	 * {@link NetworkDisconnectedException} クラスのインスタンスを初期化します。
	 * @see Exception#Exception()
	 * @since 1.0.0
	 */
	public NetworkDisconnectedException() {
		super();
	}
	
	/**
	 * {@link NetworkDisconnectedException} クラスのインスタンスを初期化します。
	 * @param message　エラー内容です。
	 * @see Exception#Exception(String)
	 * @since 1.0.0
	 */
	public NetworkDisconnectedException(String message) {
		super(message);
	}
	
	/**
	 * {@link NetworkDisconnectedException} クラスのインスタンスを初期化します。
	 * @param cause エラーの原因となる {@link Throwable} オブジェクトです。
	 * @see Exception#Exception(Throwable)
	 * @since 1.0.0
	 */
	public NetworkDisconnectedException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * {@link NetworkDisconnectedException} クラスのインスタンスを初期化します。
	 * @param message　エラー内容です。
	 * @param cause エラーの原因となる {@link Throwable} オブジェクトです。
	 * @see Exception#Exception(String, Throwable)
	 * @since 1.0.0
	 */
	public NetworkDisconnectedException(String message, Throwable cause) {
		super(message, cause);
	}
}
