package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.ContentMarkingDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class ContentMarkingDao extends AbstractDao {

	/*package*/ ContentMarkingDao() {}

	@Override
	protected ContentMarkingDto convert(Cursor cursor) {
		ContentMarkingDto dto = new ContentMarkingDto();

		int colnum = cursor.getColumnIndex("content_id");
		if (colnum != -1) {
			dto.contentId = cursor.getLong(colnum);
		}
		colnum = cursor.getColumnIndex("page_num");
		if (colnum != -1) {
			dto.pageNum = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("marking_id");
		if (colnum != -1) {
			dto.markingId = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("file_name");
		if (colnum != -1) {
			dto.fileName = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("insert_date");
		if (colnum != -1) {
			dto.insertDateStr = cursor.getString(colnum);
			dto.insertDate = DateTimeUtil.toDate(dto.insertDateStr, DateTimeFormat.yyyyMMddHHmmssSSS_hyphen);
		}
		colnum = cursor.getColumnIndex("update_date");
		if (colnum != -1) {
			dto.updateDateStr = cursor.getString(colnum);
			dto.updateDate = DateTimeUtil.toDate(dto.updateDateStr, DateTimeFormat.yyyyMMddHHmmssSSS_hyphen);
		}

		return dto;
	}
	
	public List<ContentMarkingDto> getMarkingList(long contentId) {
		return rawQueryGetDtoList("select * from t_content_marking where content_id=? order by page_num", new String[]{""+ contentId}, ContentMarkingDto.class);
	}
	
	public List<ContentMarkingDto> getAllMarkingList() {
		return rawQueryGetDtoList("select * from t_content_marking", null, ContentMarkingDto.class);
	}
	
	public ContentMarkingDto getMarking(long contentId, int pageNum) {
		return rawQueryGetDto("select * from t_content_marking where content_id=? AND page_num=?", new String[]{""+ contentId, ""+ pageNum}, ContentMarkingDto.class);
	}

	public void insertMarking(ContentMarkingDto dto) {
		insert("insert into t_content_marking (content_id, page_num, marking_id, file_name, insert_date, update_date) values (?,?,?,?,?,?)", dto.getInsertValues());
	}

	public void deleteMarking(long contentId) {
		delete("t_content_marking", "content_id=?", new String[] { "" + contentId });
	}

	public void deleteMarking(long contentId, int pageNum) {
		delete("t_content_marking", "content_id=? and page_num=?", new String[] { "" + contentId, "" + pageNum });
	}
	
	public boolean updateMarking(ContentMarkingDto dto) {
		long count = update("update t_content_marking set marking_id=?, file_name=?, update_date=? where content_id=? and page_num=? ", dto.getUpdateValues());
		return (count > 0);
	}
}
