package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.acms.type.ContentReadingStatus;
import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.ContentPageReadingLogDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class ContentPageReadingLogDao extends AbstractDao {

	/**
	 * {@link MemberInfoDao} のインスタンスを初期化します。
	 * context アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	ContentPageReadingLogDao() {
	}

	@Override
	protected ContentPageReadingLogDto convert(Cursor cursor) {
		ContentPageReadingLogDto dto = new ContentPageReadingLogDto();

		int colnum = cursor.getColumnIndex("page_reading_log_id");
		if (colnum != -1) {
			dto.pageReadingLogId = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("reading_log_id");
		if (colnum != -1) {
			dto.readingLogId = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("content_id");
		if (colnum != -1) {
			dto.contentId = cursor.getLong(colnum);
		}
		colnum = cursor.getColumnIndex("page_num");
		if (colnum != -1) {
			dto.pageNum = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("status");
		if (colnum != -1) {
			dto.status = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("start_date");
		if (colnum != -1) {
			dto.startDate = DateTimeUtil.toDate(cursor.getString(colnum), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		colnum = cursor.getColumnIndex("resume_date");
		if (colnum != -1) {
			dto.resumeDate = DateTimeUtil.toDate(cursor.getString(colnum), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		colnum = cursor.getColumnIndex("end_date");
		if (colnum != -1) {
			dto.endDate = DateTimeUtil.toDate(cursor.getString(colnum), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		colnum = cursor.getColumnIndex("duration");
		if (colnum != -1) {
			dto.duration = cursor.getInt(colnum);
		}

		return dto;
	}

	public int getNewContentPageReadingLogId() {
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT ");
		sql.append(" COALESCE(MAX(page_reading_log_id)+1,1)");
		sql.append(" FROM l_content_page_reading_log");
		return rawQueryGetInt(sql.toString(), null);
	}

	public ContentPageReadingLogDto getContentPageReadingLog(long contentId, int pageNum, long readingLogId) {
		String[] args = new String[] { "" + contentId, "" + pageNum, "" + readingLogId, "" + ContentReadingStatus.reading.type(), "" + ContentReadingStatus.suspend.type() };
		return rawQueryGetDto("select * from l_content_page_reading_log where content_id=? and page_num=? and reading_log_id=? and status IN(?,?)", args, ContentPageReadingLogDto.class);
	}

	public List<ContentPageReadingLogDto> getContentPageReadLogs(long contentId, int readingLogId) {
		String[] args = new String[] { "" + contentId, "" + readingLogId };
		return rawQueryGetDtoList("select * from l_content_page_reading_log where content_id=? and reading_log_id=?", args, ContentPageReadingLogDto.class);
	}

	public void insertContentPageReadingLog(ContentPageReadingLogDto dto) {
		insert("insert into l_content_page_reading_log (page_reading_log_id, reading_log_id, content_id, page_num, status, start_date, resume_Date, end_date, duration) values (?,?,?,?,?,?,?,?,?)", dto.getInsertValues());
	}

	public boolean updateContentPageReadingLog(ContentPageReadingLogDto dto) {
		long count = update("update l_content_page_reading_log set reading_log_id=?, content_id=?, page_num=?, status=?, start_date=?, resume_Date=?, end_date=?, duration=? where page_reading_log_id=?", dto.getUpdateValues());
		return count > 0;
	}

	public boolean deleteContentPageReadingLog(long contentId, int readingLogId) {
		String[] args = new String[] { "" + contentId, "" + readingLogId};
		long ret = delete("l_content_page_reading_log", "content_id=? and reading_log_id=?", args);
		return ret > 0;
	}
}