package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.common.db.SQLiteStatement;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.dto.OperationContentDto;

/**
 * Created by leej on 2018/08/23.
 */

public class OperationContentDao extends AbstractDao {
    private static final String TAG = "OperationContentDao";
    /*package*/ OperationContentDao() {
    }
    private ContentDao contentDao = AbstractDao.getDao(ContentDao.class);

    @Override
    public OperationContentDto convert(Cursor cursor) {
        OperationContentDto dto = new OperationContentDto();

        int colnum = cursor.getColumnIndex("operation_id");
        if (colnum != -1) {
            dto.operationId = cursor.getLong(colnum);
        }
        colnum = cursor.getColumnIndex("content_id");
        if (colnum != -1) {
            dto.contentId = cursor.getLong(colnum);
        }
        colnum = cursor.getColumnIndex("operation_content_flg");
        if (colnum != -1) {
            dto.operationContentFlg = toBool(cursor.getInt(colnum));
        }

        return dto;
    }
    public List<OperationContentDto> getOperationContent(Long operationId) {
        return rawQueryGetDtoList("select * from r_operation_content where operation_id=?", new String[]{""+ operationId}, OperationContentDto.class);
    }

    public OperationContentDto getOperationMainContent(Long operationId) {
        return rawQueryGetDto("select * from r_operation_content where operation_content_flg = 1 AND operation_id=?", new String[]{""+ operationId}, OperationContentDto.class);
    }

    public List<ContentDto> getOperationRelatedContent(Long operationId) {
        return rawQueryGetDtoList("select * from r_operation_content where operation_content_flg = 0 AND operation_id=?", new String[]{""+ operationId}, ContentDto.class);
    }

    public OperationContentDto getOperationContentForContentId(Long contentId) {
        return rawQueryGetDto("select * from r_operation_content where operation_content_flg = 1 AND content_id=?", new String[]{""+ contentId}, OperationContentDto.class);
    }

    public boolean isExistMainOperationContent(Long operationId) {
        return getOperationMainContent(operationId) != null;
    }

    public List<Long> getContentIds(Long operationId) {
        return rawQueryGetLongList("select content_id from r_operation_content where operation_id=?", new String[]{""+ operationId});
    }

    /**
     * 資料IDに紐づいた作業が存在しないと資料を削除する判定
     * @param contentId
     * @return
     */
    public boolean isDeleteContent (Long contentId) {
        return rawQueryGetInt("select COUNT(*) from r_operation_content where content_id=?", new String[]{"" + contentId }) == 0;
    }

    public boolean insertOperationContent(OperationContentDto dto) {

        StringBuffer sql = new StringBuffer();

        sql.append(" INSERT OR IGNORE INTO r_operation_content ");
        sql.append(" SELECT " + dto.operationId);
        sql.append("      , " + dto.contentId);
        sql.append("      , " + (dto.operationContentFlg ? 1 : 0));
        sql.append("   FROM t_content AS tc ");
        sql.append("   LEFT OUTER JOIN r_operation_content AS rpc ");
        sql.append("     ON rpc.operation_id = ? ");
        sql.append("    AND rpc.operation_content_flg = " + (dto.operationContentFlg ? 1 : 0));
        sql.append("    AND tc.content_id <> rpc.content_id ");
        sql.append("  WHERE tc.content_id = ? ");
        sql.append("  GROUP BY rpc.operation_id ");

        SQLiteStatement stmt = null;

        Logger.v(TAG, "sql=%s", sql);
        try {
            SQLiteDatabase db = getDatabase();
            stmt = db.compileStatement(sql.toString());
            stmt.bindLong(1, dto.operationId);
            stmt.bindLong(2, dto.contentId);

            return (stmt.executeInsert() > 0);
        } finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /**
     * リストを削除
     * @param operationId
     * @param contentId
     */
    public void deleteOperationContent(Long operationId, Long contentId) {
        delete("r_operation_content", "operation_id=? and content_id=?", new String[] { ""+operationId, "" + contentId });
    }
}
