package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

public class LContentReadingLog extends SQLiteTableScript {
	
	public LContentReadingLog() {
		super();
	}

	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();

		// since 1.0.0
		sql.append(" CREATE TABLE l_content_reading_log ( ");
		sql.append("        reading_log_id INTEGER NOT NULL ");
		sql.append("      , content_id BIGINT NOT NULL ");
		sql.append("      , status CHAR(1) NOT NULL DEFAULT '1' ");
		sql.append("      , start_date DATETIME NOT NULL ");
		sql.append("      , resume_date DATETIME ");
		sql.append("      , end_date DATETIME ");
		sql.append("      , duration INTEGER ");
		sql.append("      , latitude REAL ");
		sql.append("      , longitude REAL ");
		sql.append("      , mode INTEGER default 0 ");
		sql.append("      , PRIMARY KEY (reading_log_id) ");
		sql.append(" ) ");

		ddl.add(sql.toString());

		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
