package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

/**
 * Created by leej on 2019/06/25.
 */

public class ROperationGroupMasterOperation extends SQLiteTableScript {

    public ROperationGroupMasterOperation() {
        super();
    }

    @Override
    public List<String> getCreateScript(int version) {
        List<String> ddl = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();

        sql.append(" CREATE TABLE r_operation_group_master_relation ( ");
        sql.append("        operation_group_master_id INTEGER NOT NULL ");
        sql.append("      , operation_id BIGINT NOT NULL ");
        sql.append("      , PRIMARY KEY (operation_group_master_id, operation_id)      ");
        sql.append("      , FOREIGN KEY (operation_group_master_id) REFERENCES m_operation_group_master (operation_group_master_id) ");
        sql.append("      , FOREIGN KEY (operation_id) REFERENCES t_operation (operation_id)");
        sql.append(" ) ");

        ddl.add(sql.toString());

        return ddl;
    }

    @Override
    public List<String> getUpgradeScript(int oldVersion, int newVersion) {
        List<String> ddl = new ArrayList<String>();
        if (oldVersion < DatabaseVersions.Ver1_1_0) {
            ddl.addAll(getCreateScript(newVersion));
        }
        return ddl;
    }

    @Override
    public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
        return null;
    }
}