package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

/**
 * TODO: ContentDtoに統合したのでいずれかの段階で削除
 * @version 1.1.0
 */
public class TContentDownloadQueue extends SQLiteTableScript {
	
	public TContentDownloadQueue() {
		super();
	}

	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since 1.0.0
		sql.append(" CREATE TABLE t_content_download_queue ( ");
		sql.append("        content_id BIGINT NOT NULL ");
		sql.append("      , resource_version NOT NULL ");
		sql.append("      , status VARCHAR(2) NOT NULL ");
		sql.append("      , display_status VARCHAR(2) NOT NULL ");	//	since 1.5.0
		sql.append("      , message_code TEXT ");	//	since 1.5.0
		sql.append("      , queued_date DATETIME NOT NULL ");
		sql.append("      , start_date DATETIME ");
		sql.append("      , download_avg_bps REAL ");
		sql.append("      , download_progress INTEGER ");
		sql.append("      , resource_downloaded_bytes BIGINT ");
		sql.append("      , resource_downloaded_file_path VARCHAR(255) ");
		sql.append("      , resource_download_end_date DATETIME ");
		sql.append("      , image_downloaded_bytes BIGINT ");
		sql.append("      , image_download_end_date DATETIME ");
		sql.append("      , resource_extract_end_date DATETIME ");
		sql.append("      , image_extract_end_date DATETIME ");
		sql.append("      , end_date DATETIME ");
		sql.append("      , log_sended_flg BOOLEAN ");
		sql.append("      , PRIMARY KEY (content_id) ");
		sql.append("      , FOREIGN KEY (content_id) REFERENCES t_content (content_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		
		ddl.add(" CREATE INDEX idx_content_download_queue_queued_date ON t_content_download_queue (queued_date) ");
		ddl.add(" CREATE INDEX idx_content_download_queue_end_date ON t_content_download_queue (end_date) ");

		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}
}
