package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;

public class TContentDownloadStatus extends SQLiteTableScript {
	
	public TContentDownloadStatus() {
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since 1.0.0
		sql.append(" CREATE TABLE t_content_download_status ( ");
		sql.append("        content_id BIGINT NOT NULL ");
		sql.append("      , status CHAR(1) NOT NULL ");
		sql.append("      , start_date DATETIME NOT NULL ");
		sql.append("      , end_date DATETIME ");
		sql.append("      , resource_version INTEGER ");
		sql.append("      , progress_value INTEGER ");
		sql.append("      , PRIMARY KEY (content_id) ");
		sql.append("      , FOREIGN KEY (content_id) REFERENCES t_content (content_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		
		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
