package jp.agentec.abook.abv.bl.download;

import jp.agentec.adf.net.http.HttpDownloadSimpleNotification;

/**
 * コンテンツ情報のダウンロードに関するイベントを定義します。
 * @author Taejin Hong
 * @version 1.1.0
 */
public interface ContentDownloadListener {
	/**
	 * 
	 * 新着コンテンツ情報が更新されたことを通知します。
	 * @param result 更新結果です。
	 * @param contentId 更新されたコンテンツID。全体の終了・エラーの場合は-1。現状使われていないが、ログ等の利用のため残す。
	 * @param e
	 * @since 1.0.0
	 */
    void onRefreshedContent(boolean result, long contentId, Exception e);
	/**
	 * コンテンツ詳細情報がダウンロードされたことを通知します。
	 * @param notification ダウンロードした情報を格納するオブジェクトです。
	 * @since 1.0.0
	 */
    void onDownloadedContentDetail(HttpDownloadSimpleNotification notification);
	/**
	 * コンテンツダウンロードの際、ダウンロードの状態変化を通知します。
	 * @param notification ダウンロードに関する情報を格納するオブジェクトです。
	 * @since 1.0.0
	 */
    void onDownloadingContentZip(ContentZipDownloadNotification notification);
	/**
	 * ACMSへの認証が失敗したので、更新・ダウンロードができないことを通知します。
	 * @since 1.1.0
	 */
    void onAuthenticationFailed();
}
